<?php

use Illuminate\Support\Facades\Route;
use App\Models\Tour;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Dubai Tour Seed Route - tarayıcıdan /seed-dubai-tour yazınca Dubai turunu seed eder
Route::get('/seed-dubai-tour', function () {
    try {
        // Sadece localhost'tan erişilebilir (güvenlik)
        if (!in_array(request()->ip(), ['127.0.0.1', '::1', 'localhost'])) {
            return response()->json([
                'success' => false,
                'error' => 'Bu route sadece localhost\'tan erişilebilir'
            ], 403);
        }

        // DubaiTourSeeder'ı çalıştır
        \Artisan::call('db:seed', [
            '--class' => 'Database\Seeders\DubaiTourSeeder',
            '--force' => true
        ]);

        $output = \Artisan::output();

        // Dubai turunu kontrol et
        $dubaiTour = \App\Models\Tour::where('code', 'DXB-5D')->first();

        return response()->json([
            'success' => true,
            'message' => 'Dubai turu başarıyla seed edildi!',
            'output' => $output,
            'tour' => $dubaiTour ? [
                'id' => $dubaiTour->id,
                'code' => $dubaiTour->code,
                'title' => $dubaiTour->title,
                'has_description' => !empty($dubaiTour->description),
                'has_itinerary' => !empty($dubaiTour->itinerary),
                'has_images' => !empty($dubaiTour->images),
                'dates_count' => $dubaiTour->dates()->count(),
            ] : null
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'error' => $e->getMessage(),
            'trace' => config('app.debug') ? $e->getTraceAsString() : null
        ], 500);
    }
});

// Debug route - API'den gelen tour verisini gösterir
Route::get('/debug-tour/{id}', function ($id) {
    try {
        $tour = \App\Models\Tour::with(['brand', 'dates', 'categories', 'guide', 'assistant'])
            ->findOrFail($id);

        // JSON alanlarını parse et
        $description = is_string($tour->description) ? json_decode($tour->description, true) : $tour->description;
        $itinerary = is_string($tour->itinerary) ? json_decode($tour->itinerary, true) : $tour->itinerary;
        $images = is_string($tour->images) ? json_decode($tour->images, true) : $tour->images;
        $included = is_string($tour->included) ? json_decode($tour->included, true) : $tour->included;
        $excluded = is_string($tour->excluded) ? json_decode($tour->excluded, true) : $tour->excluded;
        $highlights = is_string($tour->highlights) ? json_decode($tour->highlights, true) : $tour->highlights;

        return response()->json([
            'success' => true,
            'tour' => [
                'id' => $tour->id,
                'code' => $tour->code,
                'title' => $tour->title,
                'type' => $tour->type,
                'description' => $description,
                'itinerary' => $itinerary,
                'images' => $images,
                'included' => $included,
                'excluded' => $excluded,
                'highlights' => $highlights,
                'dates_count' => $tour->dates()->count(),
                'raw_description' => $tour->description, // Ham JSON string
                'raw_itinerary' => $tour->itinerary, // Ham JSON string
            ],
            'dates' => $tour->dates->map(function ($date) {
                return [
                    'id' => $date->id,
                    'start_date' => $date->start_date,
                    'end_date' => $date->end_date,
                    'adult_price' => $date->adult_price,
                    'capacity' => $date->capacity,
                    'booked' => $date->booked,
                ];
            })
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'error' => $e->getMessage()
        ], 500);
    }
});

// Seed route - tarayıcıdan /seed-tours yazınca turların içeriklerini doldurur
Route::get('/seed-tours', function () {
    try {
        // Bali Turu (ID: 1)
        $bali = Tour::find(1);
        if ($bali) {
            $bali->update([
                'type' => 'flight',
                'nights' => 7,
                'price' => 1299,
                'discounted_price' => 1149,
                'description' => [
                    'tr' => 'Bali, Tanrıların Adası olarak bilinen bu büyüleyici destinasyonda unutulmaz bir tatil sizi bekliyor. Hinduizm kültürünün derin izlerini taşıyan tapınaklar, yeşil pirinç terasları, berrak denizleri ve eşsiz gün batımlarıyla Bali, ruhunuzu dinlendirecek mükemmel bir kaçış noktası. Ubud\'un sanat galerilerinden Seminyak\'ın canlı gece hayatına, Uluwatu\'nun muhteşem kıyı manzaralarından Tegallalang\'ın nefes kesen pirinç teraslarına kadar her köşesinde yeni bir keşif sizi bekliyor.',
                    'de' => 'Bali, die Insel der Götter, erwartet Sie mit einem unvergesslichen Urlaub. Tempel mit tiefen Spuren der hinduistischen Kultur, grüne Reisterrassen, kristallklares Meer und einzigartige Sonnenuntergänge.',
                    'en' => 'Bali, known as the Island of Gods, awaits you with an unforgettable vacation. Temples bearing deep traces of Hindu culture, green rice terraces, crystal clear seas and unique sunsets.'
                ],
                'highlights' => [
                    'tr' => ['Ubud Maymun Ormanı', 'Tegallalang Pirinç Terasları', 'Tanah Lot Tapınağı', 'Uluwatu Tapınağı ve Kecak Dansı', 'Seminyak Plajı', 'Tirta Empul Su Tapınağı', 'Bali Swing'],
                    'de' => ['Ubud Affenwald', 'Tegallalang Reisterrassen', 'Tanah Lot Tempel', 'Uluwatu Tempel', 'Seminyak Strand'],
                    'en' => ['Ubud Monkey Forest', 'Tegallalang Rice Terraces', 'Tanah Lot Temple', 'Uluwatu Temple', 'Seminyak Beach']
                ],
                'included' => [
                    'tr' => ['Gidiş-dönüş uçak bileti', '6 gece 4-5 yıldızlı otel konaklaması', 'Günlük kahvaltı', 'Havalimanı transferleri', 'Rehberli tur programı', 'Tapınak giriş ücretleri', 'Klimalı araç ile ulaşım'],
                    'de' => ['Hin- und Rückflug', '6 Nächte im 4-5 Sterne Hotel', 'Tägliches Frühstück', 'Flughafentransfers', 'Geführte Tour'],
                    'en' => ['Round trip flight tickets', '6 nights at 4-5 star hotel', 'Daily breakfast', 'Airport transfers', 'Guided tour program']
                ],
                'excluded' => [
                    'tr' => ['Kişisel harcamalar', 'Öğle ve akşam yemekleri', 'Vize ücreti (gerekirse)', 'Seyahat sigortası', 'Ekstra aktiviteler'],
                    'de' => ['Persönliche Ausgaben', 'Mittag- und Abendessen', 'Visakosten', 'Reiseversicherung'],
                    'en' => ['Personal expenses', 'Lunch and dinner', 'Visa fee', 'Travel insurance']
                ],
                'itinerary' => [
                    ['day' => 1, 'title' => 'Varış ve Ubud Keşfi', 'stops' => [
                        ['name' => 'Ngurah Rai Havalimanı Varış', 'time' => '06:00', 'description' => 'Bali havalimanına varış ve karşılama'],
                        ['name' => 'Ubud Maymun Ormanı', 'time' => '10:00', 'description' => 'Kutsal maymun ormanını keşfedin'],
                        ['name' => 'Tegallalang Pirinç Terasları', 'time' => '14:00', 'description' => 'UNESCO Dünya Mirası pirinç terasları'],
                        ['name' => 'Otel Check-in', 'time' => '18:00', 'description' => 'Ubud\'daki otelinize yerleşme']
                    ], 'images' => ['https://images.unsplash.com/photo-1537996194471-e657df975ab4?w=800', 'https://images.unsplash.com/photo-1555400038-63f5ba517a47?w=800']],
                    ['day' => 2, 'title' => 'Tapınaklar ve Kültür', 'stops' => [
                        ['name' => 'Tirta Empul Su Tapınağı', 'time' => '09:00', 'description' => 'Kutsal su arınma ritüeli'],
                        ['name' => 'Gunung Kawi Tapınağı', 'time' => '12:00', 'description' => '11. yüzyıldan kalma kaya tapınağı'],
                        ['name' => 'Ubud Sanat Pazarı', 'time' => '15:00', 'description' => 'El yapımı hediyelik eşyalar']
                    ], 'images' => ['https://images.unsplash.com/photo-1518548419970-58e3b4079ab2?w=800']],
                    ['day' => 3, 'title' => 'Tanah Lot ve Gün Batımı', 'stops' => [
                        ['name' => 'Taman Ayun Tapınağı', 'time' => '10:00', 'description' => 'Kraliyet tapınağı ziyareti'],
                        ['name' => 'Tanah Lot Tapınağı', 'time' => '16:00', 'description' => 'Deniz üzerindeki ikonik tapınak ve gün batımı']
                    ], 'images' => ['https://images.unsplash.com/photo-1604999333679-b86d54738315?w=800']]
                ],
                'images' => [
                    'https://images.unsplash.com/photo-1537996194471-e657df975ab4?w=1200',
                    'https://images.unsplash.com/photo-1555400038-63f5ba517a47?w=1200',
                    'https://images.unsplash.com/photo-1518548419970-58e3b4079ab2?w=1200',
                    'https://images.unsplash.com/photo-1604999333679-b86d54738315?w=1200',
                    'https://images.unsplash.com/photo-1539367628448-4bc5c9d171c8?w=1200'
                ]
            ]);

            // Bali tarihleri
            $bali->dates()->delete();
            $bali->dates()->createMany([
                ['start_date' => '2025-03-15', 'end_date' => '2025-03-22', 'adult_price' => 1299, 'adult_discounted_price' => 1149, 'child_price' => 899, 'baby_price' => 0, 'capacity' => 30, 'booked' => 12],
                ['start_date' => '2025-04-10', 'end_date' => '2025-04-17', 'adult_price' => 1399, 'adult_discounted_price' => 1249, 'child_price' => 949, 'baby_price' => 0, 'capacity' => 30, 'booked' => 8],
                ['start_date' => '2025-05-01', 'end_date' => '2025-05-08', 'adult_price' => 1499, 'adult_discounted_price' => 1349, 'child_price' => 999, 'baby_price' => 0, 'capacity' => 25, 'booked' => 20],
                ['start_date' => '2025-06-15', 'end_date' => '2025-06-22', 'adult_price' => 1599, 'adult_discounted_price' => 1449, 'child_price' => 1049, 'baby_price' => 0, 'capacity' => 30, 'booked' => 5]
            ]);
        }

        // Dubai Turu (ID: 2)
        $dubai = Tour::find(2);
        if ($dubai) {
            $dubai->update([
                'type' => 'flight',
                'nights' => 5,
                'price' => 899,
                'discounted_price' => 799,
                'description' => [
                    'tr' => 'Dünyanın en lüks ve modern şehirlerinden biri olan Dubai\'de unutulmaz bir tatil sizi bekliyor. Burj Khalifa\'nın görkeminden Palm Jumeirah\'ın ihtişamına, geleneksel Altın Çarşı\'dan modern Dubai Mall\'a kadar her köşesinde farklı bir deneyim yaşayacaksınız. Çöl safarisi, dhow cruise ve su parkları ile dolu aksiyonlu bir tatil için Dubai mükemmel seçim!',
                    'de' => 'Ein unvergesslicher Urlaub erwartet Sie in Dubai, einer der luxuriösesten und modernsten Städte der Welt. Von der Pracht des Burj Khalifa bis zur Majestät von Palm Jumeirah.',
                    'en' => 'An unforgettable vacation awaits you in Dubai, one of the most luxurious and modern cities in the world. From the magnificence of Burj Khalifa to the grandeur of Palm Jumeirah.'
                ],
                'highlights' => [
                    'tr' => ['Burj Khalifa Gözlem Terası', 'Dubai Mall ve Akvaryum', 'Çöl Safarisi', 'Palm Jumeirah Turu', 'Altın Çarşı Ziyareti', 'Dhow Cruise Akşam Yemeği', 'Dubai Marina Yürüyüşü', 'Atlantis Aquaventure'],
                    'de' => ['Burj Khalifa Aussichtsterrasse', 'Dubai Mall', 'Wüstensafari', 'Palm Jumeirah', 'Gold Souk'],
                    'en' => ['Burj Khalifa Observation Deck', 'Dubai Mall and Aquarium', 'Desert Safari', 'Palm Jumeirah Tour', 'Gold Souk Visit']
                ],
                'included' => [
                    'tr' => ['Gidiş-dönüş uçak bileti', '4 gece 5 yıldızlı otel konaklaması', 'Günlük kahvaltı buffet', 'Havalimanı VIP transferleri', 'Burj Khalifa giriş bileti', 'Çöl safarisi (akşam yemeği dahil)', 'Dhow cruise dinner', 'Dubai city turu', 'Profesyonel Türkçe rehber'],
                    'de' => ['Hin- und Rückflug', '4 Nächte im 5-Sterne Hotel', 'Tägliches Frühstücksbuffet', 'VIP Flughafentransfers', 'Burj Khalifa Eintrittskarte'],
                    'en' => ['Round trip flight tickets', '4 nights at 5-star hotel', 'Daily breakfast buffet', 'VIP airport transfers', 'Burj Khalifa entrance ticket']
                ],
                'excluded' => [
                    'tr' => ['Kişisel harcamalar', 'Öğle yemekleri', 'Ekstra aktiviteler', 'Seyahat sigortası', 'İçecekler (cruise hariç)', 'Vize ücreti'],
                    'de' => ['Persönliche Ausgaben', 'Mittagessen', 'Zusätzliche Aktivitäten', 'Reiseversicherung'],
                    'en' => ['Personal expenses', 'Lunches', 'Extra activities', 'Travel insurance']
                ],
                'itinerary' => [
                    ['day' => 1, 'title' => 'Dubai Varış', 'stops' => [
                        ['name' => 'Dubai Havalimanı Varış', 'time' => '08:00', 'description' => 'VIP karşılama ve transfer'],
                        ['name' => 'Otel Check-in', 'time' => '12:00', 'description' => 'Downtown Dubai\'deki lüks otelinize yerleşme'],
                        ['name' => 'Dubai Mall Keşfi', 'time' => '16:00', 'description' => 'Dünyanın en büyük alışveriş merkezini keşfedin'],
                        ['name' => 'Dubai Fountain Show', 'time' => '20:00', 'description' => 'Işık ve su gösterisi']
                    ], 'images' => ['https://images.unsplash.com/photo-1512453979798-5ea266f8880c?w=800', 'https://images.unsplash.com/photo-1582672060674-bc2bd808a8e5?w=800']],
                    ['day' => 2, 'title' => 'Burj Khalifa ve Modern Dubai', 'stops' => [
                        ['name' => 'Burj Khalifa At The Top', 'time' => '09:00', 'description' => '148. kattan Dubai manzarası'],
                        ['name' => 'Dubai Akvaryum', 'time' => '12:00', 'description' => '33.000 deniz canlısı'],
                        ['name' => 'Dubai Marina Yürüyüşü', 'time' => '17:00', 'description' => 'Gökdelenlerin gölgesinde yürüyüş']
                    ], 'images' => ['https://images.unsplash.com/photo-1518684079-3c830dcef090?w=800']],
                    ['day' => 3, 'title' => 'Çöl Safarisi', 'stops' => [
                        ['name' => 'Serbest Zaman', 'time' => '10:00', 'description' => 'Havuz veya plaj keyfi'],
                        ['name' => 'Çöl Safarisi Başlangıç', 'time' => '15:00', 'description' => '4x4 araçlarla çöl macerası'],
                        ['name' => 'Deve Binme', 'time' => '17:30', 'description' => 'Geleneksel deve yolculuğu'],
                        ['name' => 'BBQ Akşam Yemeği', 'time' => '19:00', 'description' => 'Belly dance ve tanoura show eşliğinde']
                    ], 'images' => ['https://images.unsplash.com/photo-1451337516015-6b6e9a44a8a3?w=800']],
                    ['day' => 4, 'title' => 'Geleneksel Dubai ve Dhow Cruise', 'stops' => [
                        ['name' => 'Altın Çarşı', 'time' => '10:00', 'description' => 'Deira Gold Souk ziyareti'],
                        ['name' => 'Baharat Çarşısı', 'time' => '12:00', 'description' => 'Otantik Arap baharatları'],
                        ['name' => 'Abra Boat Ride', 'time' => '14:00', 'description' => 'Dubai Creek\'te geleneksel tekne'],
                        ['name' => 'Dhow Cruise Dinner', 'time' => '20:00', 'description' => 'Dubai Marina\'da akşam yemeği cruise']
                    ], 'images' => ['https://images.unsplash.com/photo-1526495124232-a04e1849168c?w=800']],
                    ['day' => 5, 'title' => 'Palm Jumeirah ve Dönüş', 'stops' => [
                        ['name' => 'Palm Jumeirah Turu', 'time' => '09:00', 'description' => 'Dünyanın en büyük yapay adası'],
                        ['name' => 'Atlantis The Palm', 'time' => '11:00', 'description' => 'İkonik otel fotoğraf molası'],
                        ['name' => 'Havalimanı Transfer', 'time' => '15:00', 'description' => 'VIP transfer ve uğurlama']
                    ], 'images' => ['https://images.unsplash.com/photo-1580674684081-7617fbf3d745?w=800']]
                ],
                'images' => [
                    'https://images.unsplash.com/photo-1512453979798-5ea266f8880c?w=1200',
                    'https://images.unsplash.com/photo-1518684079-3c830dcef090?w=1200',
                    'https://images.unsplash.com/photo-1582672060674-bc2bd808a8e5?w=1200',
                    'https://images.unsplash.com/photo-1526495124232-a04e1849168c?w=1200',
                    'https://images.unsplash.com/photo-1580674684081-7617fbf3d745?w=1200',
                    'https://images.unsplash.com/photo-1451337516015-6b6e9a44a8a3?w=1200'
                ]
            ]);

            // Dubai tarihleri
            $dubai->dates()->delete();
            $dubai->dates()->createMany([
                ['start_date' => '2025-02-20', 'end_date' => '2025-02-25', 'adult_price' => 899, 'adult_discounted_price' => 799, 'child_price' => 599, 'baby_price' => 0, 'capacity' => 40, 'booked' => 28],
                ['start_date' => '2025-03-05', 'end_date' => '2025-03-10', 'adult_price' => 949, 'adult_discounted_price' => 849, 'child_price' => 649, 'baby_price' => 0, 'capacity' => 40, 'booked' => 15],
                ['start_date' => '2025-03-20', 'end_date' => '2025-03-25', 'adult_price' => 999, 'adult_discounted_price' => 899, 'child_price' => 699, 'baby_price' => 0, 'capacity' => 35, 'booked' => 32],
                ['start_date' => '2025-04-15', 'end_date' => '2025-04-20', 'adult_price' => 1049, 'adult_discounted_price' => 949, 'child_price' => 749, 'baby_price' => 0, 'capacity' => 40, 'booked' => 10],
                ['start_date' => '2025-05-10', 'end_date' => '2025-05-15', 'adult_price' => 899, 'adult_discounted_price' => 799, 'child_price' => 599, 'baby_price' => 0, 'capacity' => 45, 'booked' => 5]
            ]);
        }

        return response()->json([
            'success' => true,
            'message' => 'Turlar başarıyla güncellendi!',
            'bali' => $bali ? 'Güncellendi' : 'Bulunamadı',
            'dubai' => $dubai ? 'Güncellendi' : 'Bulunamadı'
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'error' => $e->getMessage()
        ], 500);
    }
});

// API routes are in routes/api.php
// They are automatically prefixed with /api

// SPA Route - React Frontend
// Tüm route'ları React'e yönlendir (API hariç)
Route::get('/{any}', function () {
    $path = public_path('index.html');
    
    if (!file_exists($path)) {
        // Development modunda veya build yapılmamışsa
        return response()->json([
            'error' => 'Frontend build not found',
            'message' => 'Please run: npm run build in the frontend directory',
        ], 404);
    }
    
    return file_get_contents($path);
})->where('any', '^(?!api).*$'); // /api ile başlamayan her şey React'e
