<?php
// backend/public/debug_pickup.php

// Laravel bootstrap
require __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';

use Illuminate\Support\Facades\DB;
use App\Models\Tour;

// Create kernel to handle request (needed for some Laravel features)
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

echo "<pre>";
echo "<h1>Pickup Points Debugger</h1>";

try {
    // Get the most recently updated tour
    $tour = Tour::orderBy('updated_at', 'desc')->first();

    if (!$tour) {
        echo "No tours found.\n";
    } else {
        echo "<h2>Latest Tour: " . $tour->title['tr'] . " (ID: " . $tour->id . ")</h2>";
        
        echo "<h3>Raw Database Value (pickup_points column):</h3>";
        // Query directly to bypass Model casts for a moment to see raw DB content
        $raw = DB::table('tours')->where('id', $tour->id)->value('pickup_points');
        var_dump($raw);

        echo "\n<h3>Model Attribute (casted):</h3>";
        print_r($tour->pickup_points);

        echo "\n<h3>Tour Array Export (toArray):</h3>";
        $arr = $tour->toArray();
        if (isset($arr['pickup_points'])) {
            echo "pickup_points exists in toArray(). Content:\n";
            var_dump($arr['pickup_points']);
        } else {
            echo "WARNING: pickup_points is MISSING in toArray() result!\n";
        }
    }

} catch (\Exception $e) {
    echo "Error: " . $e->getMessage();
}

echo "</pre>";
