<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Visa;
use App\Models\Brand;
use Illuminate\Support\Facades\DB;

class VisaExampleSeeder extends Seeder
{
    public function run(): void
    {
        // Temizle
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Visa::truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        $brands = Brand::all();
        $brandIds = $brands->pluck('id')->toArray();

        $visas = [
            [
                'title' => 'Dubai (BAE) Turistik Vize - 30 Gün',
                'slug' => 'dubai-turistik-vize-30-gun',
                'price' => 120.00,
                'processing_time' => '24-48 Saat',
                'description' => 'Dubai seyahatleriniz için hızlı ve kolay 30 günlük turistik vize başvurusu. Tek girişli vizedir.',
                'requirements' => [
                    'Pasaportun renkli taraması (en az 6 ay geçerli)',
                    'Biyometrik fotoğraf (arka fon beyaz)',
                    'Uçak bileti rezervasyonu',
                    'Otel rezervasyonu'
                ],
                'is_active' => true,
            ],
            [
                'title' => 'Dubai (BAE) Turistik Vize - 60 Gün',
                'slug' => 'dubai-turistik-vize-60-gun',
                'price' => 180.00,
                'processing_time' => '48-72 Saat',
                'description' => 'Daha uzun süreli Dubai ziyaretleriniz için 60 günlük çok girişli turistik vize.',
                'requirements' => [
                    'Pasaportun renkli taraması (en az 6 ay geçerli)',
                    'Biyometrik fotoğraf (arka fon beyaz)',
                    'Konaklama bilgileri',
                    'Banka hesap dökümü (bazı durumlarda)'
                ],
                'is_active' => true,
            ],
            [
                'title' => 'Suudi Arabistan Umre Vizesi',
                'slug' => 'suudi-arabistan-umre-vizesi',
                'price' => 150.00,
                'processing_time' => '3-5 İş Günü',
                'description' => 'Umre ziyareti gerçekleştirecek olan misafirlerimiz için resmi vize başvuru süreci.',
                'requirements' => [
                    'Pasaport aslı (en az 1 yıl geçerli)',
                    '2 adet biyometrik fotoğraf',
                    'Aşı sertifikası (güncel gerekliliklere göre)',
                    'Nüfus cüzdanı fotokopisi'
                ],
                'is_active' => true,
            ],
            [
                'title' => 'Mısır Kapı Vizesi ve Ön Onay',
                'slug' => 'misir-kapi-vizesi',
                'price' => 45.00,
                'processing_time' => '24 Saat',
                'description' => 'Mısır seyahati öncesi online ön onay ve kapı vizesi işlemlerinin koordinasyonu.',
                'requirements' => [
                    'Pasaport taraması',
                    'Uçak ve Otel rezervasyonları',
                    'Seyahat sağlık sigortası'
                ],
                'is_active' => true,
            ],
            [
                'title' => 'İngiltere (UK) Standart Ziyaretçi Vizesi',
                'slug' => 'ingiltere-standart-ziyaretci-vizesi',
                'price' => 145.00,
                'processing_time' => '15 İş Günü',
                'description' => 'İngiltere turistik ve iş ziyaretleriniz için gerekli olan 6 aylık standart ziyaretçi vizesi danışmanlığı.',
                'requirements' => [
                    'Pasaport aslı',
                    'Detaylı çalışan/işveren evrakları',
                    'Banka hesap özetleri (son 6 aylık)',
                    'Konaklama ve uçuş planı'
                ],
                'is_active' => true,
            ],
        ];

        foreach ($visas as $visaData) {
            $requirements = $visaData['requirements'];
            unset($visaData['requirements']);
            
            // Rastgele 2-3 marka ile ilişkilendir
            $selectedBrandIds = [];
            if (!empty($brandIds)) {
                $randomKeys = array_rand(array_flip($brandIds), min(count($brandIds), rand(2, 3)));
                $selectedBrandIds = is_array($randomKeys) ? $randomKeys : [$randomKeys];
            }

            $visaData['brand_ids'] = $selectedBrandIds;
            $visaData['requirements'] = $requirements;
            $visaData['agent_group_ids'] = []; // Boş bırak
            
            Visa::create($visaData);
        }
    }
}
