<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Villa;
use Illuminate\Support\Facades\DB;

class VillaExampleSeeder extends Seeder
{
    public function run(): void
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Villa::truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        Villa::create([
            'title' => ['tr' => 'Villa Azure - Kalkan', 'de' => 'Villa Azure - Kalkan', 'en' => 'Villa Azure - Kalkan'],
            'slug' => 'villa-azure-kalkan',
            'price' => 450,
            'discounted_price' => 395,
            'location' => 'Kalamar Koyu, Kalkan, Antalya',
            'capacity_adults' => 8,
            'capacity_children' => 2,
            'bedrooms' => 4,
            'bathrooms' => 4,
            'area_sqm' => 250,
            'min_stay' => 5,
            'damage_deposit' => 500,
            'cleaning_fee' => 100,
            'pool_type' => 'Özel Sonsuzluk Havuzu',
            'checkin_time' => '15:00',
            'checkout_time' => '10:00',
            'description' => ['tr' => 'Full deniz manzaralı, lüks mobilyalı, özel havuzlu rüya gibi bir tatil villası.', 'de' => 'Ein traumhaftes Ferienhaus mit vollem Meerblick, luxuriöser Möblierung und privatem Pool.', 'en' => 'A dream vacation villa with full sea view, luxury furniture, and private pool.'],
            'amenities' => ['Infinity Pool', 'Sea View', 'BBQ & Şömine', 'Jakuzi', 'Smart TV / Netflix', 'High-Speed WiFi'],
            'house_rules' => ['Evcil hayvan kabul edilmez', 'Sigara içilmez', 'Çocuklara uygundur'],
            'property_type_tags' => ['Müstakil Villa', 'Deniz Manzaralı'],
            'faqs' => [
                ['q' => 'Anahtar teslimi nasıl yapılıyor?', 'a' => 'Giriş günü sizi villada karşılıyoruz.'],
                ['q' => 'Havuz temizliği ne sıklıkla yapılıyor?', 'a' => 'Her sabah erken saatlerde düzenli olarak temizlenir.']
            ],
            'distances' => [
                ['label' => 'Deniz/Plaj', 'value' => '300m'],
                ['label' => 'Market', 'value' => '150m'],
                ['label' => 'Havalimanı', 'value' => '120km']
            ],
            'gallery' => [
                'https://images.unsplash.com/photo-1580587771525-78b9dba3b914?auto=format&fit=crop&q=80&w=800',
                'https://images.unsplash.com/photo-1512917774080-9991f1c4c750?auto=format&fit=crop&q=80&w=800'
            ],
            'is_active' => true,
            'brand_ids' => [1, 2],
        ]);
    }
}
