<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Tour;
use App\Models\TourDate;
use App\Models\Brand;
use Carbon\Carbon;

class MealOptionsExampleSeeder extends Seeder
{
    public function run(): void
    {
        $exampleMealOptions = [
            'categories' => [
                [
                    'key' => 'main',
                    'label' => 'Ana Yemekler',
                    'type' => 'customer_choice',
                    'options' => [
                        ['label' => 'Izgara Köfte', 'description' => 'Dana köfte, pilav ve mevsim salata ile. Geleneksel Türk lezzeti.', 'image' => 'https://images.unsplash.com/photo-1603360946369-dc9bb6968143?w=400', 'price' => 18, 'showPriceToCustomer' => true],
                        ['label' => 'Levrek Buğulama', 'description' => 'Taze levrek, zeytinyağlı sebzeler ve limon ile buğulama.', 'image' => 'https://images.unsplash.com/photo-1519708227418-c8fd9a32b7a2?w=400', 'price' => 22, 'showPriceToCustomer' => true],
                        ['label' => 'Mantı', 'description' => 'Ev yapımı mantı, sarımsaklı yoğurt ve sumaklı sos ile.', 'image' => 'https://images.unsplash.com/photo-1565299624946-b28f40a0ae38?w=400', 'price' => 14, 'showPriceToCustomer' => true],
                    ],
                ],
                [
                    'key' => 'starter',
                    'label' => 'Başlangıç',
                    'type' => 'pre_selected',
                    'options' => [
                        ['label' => 'Mevsim Yeşil Salata', 'description' => 'Taze roka, marul, domates, salatalık ve nar ekşili sos.', 'image' => 'https://images.unsplash.com/photo-1512621776951-a57141f2eefd?w=400', 'price' => 0, 'showPriceToCustomer' => false],
                        ['label' => 'Çorba (Günün Çorbası)', 'description' => 'Şefin günlük önerisi; sıcak ve taze.', 'image' => 'https://images.unsplash.com/photo-1547592166-23ac45744acd?w=400', 'price' => 0, 'showPriceToCustomer' => false],
                    ],
                ],
                [
                    'key' => 'dessert',
                    'label' => 'Tatlılar',
                    'type' => 'pre_selected',
                    'options' => [
                        ['label' => 'Künefe', 'description' => 'Tel kadayıf, antep fıstığı ve sade dondurma ile.', 'image' => 'https://images.unsplash.com/photo-1563805042-7684c019e1cb?w=400', 'price' => 0, 'showPriceToCustomer' => false],
                        ['label' => 'Sütlaç', 'description' => 'Fırın sütlaç, tarçın ile.', 'image' => 'https://images.unsplash.com/photo-1488477181946-6428a0291777?w=400', 'price' => 0, 'showPriceToCustomer' => false],
                    ],
                ],
                [
                    'key' => 'drinks',
                    'label' => 'İçecekler',
                    'type' => 'pre_selected',
                    'options' => [
                        ['label' => 'Ayran', 'description' => 'Ev yapımı soğuk ayran.', 'image' => 'https://images.unsplash.com/photo-1622597467836-f3285f2131b8?w=400', 'price' => 0, 'showPriceToCustomer' => false],
                        ['label' => 'Türk Kahvesi', 'description' => 'Geleneksel Türk kahvesi, lokum ile.', 'image' => 'https://images.unsplash.com/photo-1514432324607-a09d9b4aefdd?w=400', 'price' => 0, 'showPriceToCustomer' => false],
                    ],
                ],
            ],
        ];

        $targetDate = '2026-02-15';

        // 1) Marka al (yoksa ilk marka)
        $brand = Brand::first();
        if (!$brand) {
            $this->command->warn('Hiç marka yok. Önce bir marka oluşturun.');
            return;
        }

        // 2) DENEME TUR bul veya oluştur
        $tour = Tour::where('code', 'DENEME')->first();
        if (!$tour) {
            $tour = Tour::create([
                'brand_id' => $brand->id,
                'code' => 'DENEME',
                'title' => ['tr' => 'DENEME TUR', 'en' => 'Demo Tour', 'de' => 'Demo-Tour'],
                'slug' => 'deneme-tur',
                'type' => 'bus',
                'nights' => 1,
                'is_active' => true,
                'price' => 99,
            ]);
            $this->command->info('DENEME TUR oluşturuldu (tour_id: ' . $tour->id . ').');
        }

        // 3) 15.02.2026 tarihli tur tarihi bul veya oluştur
        $tourDate = TourDate::where('tour_id', $tour->id)
            ->whereDate('start_date', $targetDate)
            ->first();

        if (!$tourDate) {
            $tourDate = TourDate::create([
                'tour_id' => $tour->id,
                'start_date' => $targetDate,
                'end_date' => $targetDate,
                'adult_price' => 99,
                'adult_discounted_price' => 89,
                'child_price' => 49,
                'child_discounted_price' => 45,
                'baby_price' => 0,
                'baby_discounted_price' => 0,
                'capacity' => 46,
                'booked' => 0,
                'status' => 'available',
                'meal_options' => $exampleMealOptions,
            ]);
            $this->command->info('15.02.2026 tarihi eklendi ve örnek yemekler veritabanına yazıldı (tour_date_id: ' . $tourDate->id . ').');
        } else {
            $tourDate->meal_options = $exampleMealOptions;
            $tourDate->save();
            $this->command->info('Örnek yemekler 15.02.2026 tarihine güncellendi (tour_date_id: ' . $tourDate->id . ').');
        }
    }
}
