<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Hotel;
use Illuminate\Support\Facades\DB;

class HotelExampleSeeder extends Seeder
{
    public function run(): void
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Hotel::truncate();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        Hotel::create([
            'title' => ['tr' => 'Rixos Premium Belek - The Land of Legends', 'de' => 'Rixos Premium Belek', 'en' => 'Rixos Premium Belek'],
            'slug' => 'rixos-premium-belek',
            'price' => 1250,
            'discounted_price' => 1100,
            'stars' => 5,
            'location' => 'Belek, Antalya',
            'board_basis' => 'All Inclusive',
            'collection_tag' => 'Premium Collection',
            'summary' => 'Antalya nın en seçkin otelinde rüya gibi bir tatil paketi.',
            'board_types' => ['All Inclusive Plus', 'Ultra All Inclusive'],
            'amenities' => ['SPA & Wellness', 'Aquapark', 'Özel Plaj', '7/24 Concierge'],
            'flight_details' => [
                'outbound' => [
                    'airline' => 'SunExpress',
                    'from' => 'VIE',
                    'to' => 'AYT',
                    'departure' => '07:30',
                    'arrival' => '11:15',
                    'type' => 'Direct'
                ],
                'return' => [
                    'airline' => 'SunExpress',
                    'from' => 'AYT',
                    'to' => 'VIE',
                    'departure' => '20:45',
                    'arrival' => '22:30',
                    'type' => 'Direct'
                ]
            ],
            'room_details' => [
                'title' => 'Deluxe Sea View Room',
                'description' => 'Geniş mermer banyolu, balkonlu ve full deniz manzaralı 35 m2 lüks oda.',
                'features' => ['35 m²', 'King Bed', 'Balcony', 'Sea View', 'Minibar']
            ],
            'transfer_details' => [
                'included' => true,
                'description' => 'VIP Round-trip Airport Transfer (Mercedes V-Class)'
            ],
            'dates' => [
                'start' => '2026-06-01',
                'end' => '2026-06-08',
                'duration_nights' => 7
            ],
            'highlights' => [
                'The Land of Legends Girişi Dahil',
                'Live Concerts & Events',
                'Gourmet Dining Experiences'
            ],
            'gallery' => [
                'https://images.unsplash.com/photo-1571896349842-33c89424de2d?auto=format&fit=crop&q=80&w=800',
                'https://images.unsplash.com/photo-1542314831-068cd1dbfeeb?auto=format&fit=crop&q=80&w=800'
            ],
            'video_url' => 'https://www.youtube.com/watch?v=dQw4w9WgXcQ',
            'is_active' => true,
            'brand_ids' => [1, 2, 3],
        ]);
    }
}
