<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Brand;
use App\Models\Tour;
use App\Models\TourDate;
use App\Models\TourCategory;
use App\Models\PickupPoint;
use App\Models\BankAccount;
use App\Models\Airline;

class DubaiTourSeeder extends Seeder
{
    public function run(): void
    {
        // Brand
        $brand = Brand::firstOrCreate(
            ['slug' => 'avusturya-gezi'],
            [
                'name' => 'Avusturya Gezi',
                'logo' => 'https://images.unsplash.com/photo-1599420186946-7b6fb4e297f0?w=200',
                'domain' => 'avusturyagezi.com',
                'is_active' => true,
            ]
        );

        // Categories
        $dubaiCategory = TourCategory::firstOrCreate(
            ['slug' => 'dubai-turlari'],
            ['name' => 'Dubai Turları', 'description' => 'Dubai ve BAE turları', 'is_active' => true]
        );

        $asiaCategory = TourCategory::firstOrCreate(
            ['slug' => 'uzak-dogu-turlari'],
            ['name' => 'Uzak Doğu Turları', 'description' => 'Asya ve Uzak Doğu turları', 'is_active' => true]
        );

        // Pickup Points
        $pickupPoints = [];
        $pickupData = [
            ['city' => 'Viyana', 'location' => 'Viyana Havalimanı', 'address' => 'Vienna International Airport', 'time' => '06:00', 'price' => 0],
            ['city' => 'Graz', 'location' => 'Graz Merkez', 'address' => 'Hauptplatz 1, 8010 Graz', 'time' => '05:00', 'price' => 50],
            ['city' => 'Linz', 'location' => 'Linz Hauptbahnhof', 'address' => 'Bahnhofplatz 3, 4020 Linz', 'time' => '04:30', 'price' => 75],
        ];
        foreach ($pickupData as $p) {
            $pickupPoints[] = PickupPoint::firstOrCreate(
                ['location' => $p['location'], 'city' => $p['city']],
                ['brand_id' => $brand->id, 'address' => $p['address'], 'default_time' => $p['time'], 'price_modifier' => $p['price'], 'is_active' => true]
            );
        }

        // Bank Account
        $bank = BankAccount::firstOrCreate(
            ['iban' => 'AT611904300234573201'],
            ['bank_name' => 'Erste Bank', 'account_holder' => 'Avusturya Gezi GmbH', 'account_number' => '234573201', 'swift' => 'GIBAATWWXXX', 'is_active' => true]
        );

        // Airlines
        $emirates = Airline::firstOrCreate(['code' => 'EK'], ['name' => 'Emirates', 'logo' => 'https://upload.wikimedia.org/wikipedia/commons/d/d0/Emirates_logo.svg', 'is_active' => true]);
        $singapore = Airline::firstOrCreate(['code' => 'SQ'], ['name' => 'Singapore Airlines', 'logo' => 'https://upload.wikimedia.org/wikipedia/en/6/6b/Singapore_Airlines_Logo_2.svg', 'is_active' => true]);

        // ===================== BALİ TURU GÜNCELLE =====================
        $baliTour = Tour::where('code', 'BAL-001')->first();
        if (!$baliTour) {
            $baliTour = Tour::create([
                'code' => 'BAL-001',
                'title' => 'Bali & Singapur Turu',
                'type' => 'flight',
                'nights' => 7,
                'brand_id' => $brand->id,
                'is_active' => true,
            ]);
        }
        
        if ($baliTour) {
            $baliTour->update([
                'title' => 'Bali & Singapur Turu',
                'subtitle' => 'Tropik Cennet ve Modern Şehir',
                'description' => json_encode([
                    'tr' => '<h2>Bali & Singapur\'a Hoş Geldiniz!</h2><p>Uzak Doğu\'nun iki incisi! 8 günlük turda Bali\'nin mistik tapınakları, pirinç terasları ve plajlarını keşfedecek, Singapur\'un modern atmosferini yaşayacaksınız.</p><ul><li>Ubud pirinç terasları</li><li>Tanah Lot ve Uluwatu tapınakları</li><li>Marina Bay Sands</li><li>Gardens by the Bay</li></ul>',
                    'en' => '<h2>Welcome to Bali & Singapore!</h2><p>Two gems of Southeast Asia! 8-day tour through mystical temples, rice terraces of Bali and modern Singapore.</p>',
                    'de' => '<h2>Willkommen in Bali & Singapur!</h2><p>Zwei Perlen Südostasiens in 8 Tagen erleben.</p>'
                ]),
                'itinerary' => json_encode([
                    ['day' => 1, 'title' => 'Viyana - Singapur', 'stops' => [
                        ['name' => 'Viyana Havalimanı', 'time' => '10:00', 'description' => 'Check-in ve uçuş'],
                        ['name' => 'Singapur Changi', 'time' => '06:00', 'description' => 'Varış (ertesi gün)']
                    ], 'images' => ['https://images.unsplash.com/photo-1436491865332-7a61a109cc05?w=800']],
                    ['day' => 2, 'title' => 'Singapur Şehir Turu', 'stops' => [
                        ['name' => 'Marina Bay Sands', 'time' => '09:00', 'description' => 'SkyPark panoramik manzara'],
                        ['name' => 'Merlion Park', 'time' => '11:00', 'description' => 'Singapur simgesi'],
                        ['name' => 'Gardens by the Bay', 'time' => '18:00', 'description' => 'Supertree ışık gösterisi']
                    ], 'images' => ['https://images.unsplash.com/photo-1525625293386-3f8f99389edd?w=800', 'https://images.unsplash.com/photo-1508964942454-1a56651d54ac?w=800']],
                    ['day' => 3, 'title' => 'Singapur - Bali', 'stops' => [
                        ['name' => 'Orchard Road', 'time' => '09:00', 'description' => 'Alışveriş'],
                        ['name' => 'Bali\'ye Uçuş', 'time' => '14:00', 'description' => 'Transfer ve Ubud']
                    ], 'images' => ['https://images.unsplash.com/photo-1537996194471-e657df975ab4?w=800']],
                    ['day' => 4, 'title' => 'Ubud Kültür Turu', 'stops' => [
                        ['name' => 'Tegallalang', 'time' => '08:00', 'description' => 'UNESCO pirinç terasları'],
                        ['name' => 'Tirta Empul', 'time' => '11:00', 'description' => 'Kutsal su tapınağı'],
                        ['name' => 'Ubud Pazarı', 'time' => '14:00', 'description' => 'El yapımı hediyelikler'],
                        ['name' => 'Maymun Ormanı', 'time' => '16:00', 'description' => 'Kutsal orman']
                    ], 'images' => ['https://images.unsplash.com/photo-1555400038-63f5ba517a47?w=800', 'https://images.unsplash.com/photo-1558005530-a7958896ec60?w=800']],
                    ['day' => 5, 'title' => 'Tapınak Turu', 'stops' => [
                        ['name' => 'Tanah Lot', 'time' => '06:00', 'description' => 'Gün doğumu tapınağı'],
                        ['name' => 'Uluwatu', 'time' => '17:00', 'description' => 'Uçurum tapınağı ve Kecak dansı']
                    ], 'images' => ['https://images.unsplash.com/photo-1537996194471-e657df975ab4?w=800', 'https://images.unsplash.com/photo-1552733407-5d5c46c3bb3b?w=800']],
                    ['day' => 6, 'title' => 'Plaj Günü', 'stops' => [
                        ['name' => 'Nusa Dua', 'time' => '09:00', 'description' => 'Plaj keyfi'],
                        ['name' => 'Su Sporları', 'time' => '11:00', 'description' => 'Jet ski, parasailing'],
                        ['name' => 'Jimbaran', 'time' => '17:00', 'description' => 'Gün batımı yemeği']
                    ], 'images' => ['https://images.unsplash.com/photo-1518548419970-58e3b4079ab2?w=800']],
                    ['day' => 7, 'title' => 'Serbest & Dönüş', 'stops' => [
                        ['name' => 'Serbest', 'time' => '09:00', 'description' => 'Spa veya havuz'],
                        ['name' => 'Kuta', 'time' => '14:00', 'description' => 'Son alışveriş'],
                        ['name' => 'Havalimanı', 'time' => '20:00', 'description' => 'Gece uçuşu']
                    ], 'images' => ['https://images.unsplash.com/photo-1573790387438-4da905039392?w=800']],
                    ['day' => 8, 'title' => 'Viyana Varış', 'stops' => [
                        ['name' => 'Viyana', 'time' => '14:00', 'description' => 'Varış']
                    ], 'images' => []]
                ]),
                'images' => json_encode([
                    'https://images.unsplash.com/photo-1537996194471-e657df975ab4?w=1200',
                    'https://images.unsplash.com/photo-1525625293386-3f8f99389edd?w=1200',
                    'https://images.unsplash.com/photo-1555400038-63f5ba517a47?w=1200',
                    'https://images.unsplash.com/photo-1552733407-5d5c46c3bb3b?w=1200',
                    'https://images.unsplash.com/photo-1518548419970-58e3b4079ab2?w=1200'
                ]),
                'highlights' => json_encode([
                    'tr' => ['Marina Bay Sands', 'Gardens by the Bay', 'Tegallalang Terasları', 'Tanah Lot', 'Uluwatu Kecak', 'Jimbaran Yemeği'],
                    'en' => ['Marina Bay Sands', 'Gardens by the Bay', 'Tegallalang Terraces', 'Tanah Lot', 'Uluwatu Kecak', 'Jimbaran Dinner'],
                    'de' => ['Marina Bay Sands', 'Gardens by the Bay', 'Tegallalang Terrassen', 'Tanah Lot', 'Uluwatu Kecak']
                ]),
                'included' => json_encode([
                    'tr' => ['Viyana-Singapur-Bali-Viyana uçak bileti', '2 gece Singapur 5* otel', '4 gece Bali 5* otel', 'Kahvaltılar dahil', 'Tüm transferler', 'Türkçe rehber', 'Şehir turları', 'Tapınak girişleri', 'Jimbaran akşam yemeği', 'Seyahat sigortası'],
                    'en' => ['Round-trip flights', '2 nights Singapore 5* hotel', '4 nights Bali 5* hotel', 'Breakfasts included', 'All transfers', 'English guide', 'City tours', 'Temple entrances', 'Jimbaran dinner', 'Travel insurance'],
                    'de' => ['Hin- und Rückflug', '2 Nächte Singapur 5* Hotel', '4 Nächte Bali 5* Hotel', 'Frühstück inklusive', 'Alle Transfers']
                ]),
                'excluded' => json_encode([
                    'tr' => ['Öğle yemekleri', 'Kişisel harcamalar', 'Su sporları (opsiyonel)', 'Vize ücreti', 'Ekstra bagaj'],
                    'en' => ['Lunches', 'Personal expenses', 'Water sports (optional)', 'Visa fee', 'Extra baggage'],
                    'de' => ['Mittagessen', 'Persönliche Ausgaben', 'Wassersport (optional)']
                ]),
                'pickup_points' => json_encode(array_map(fn($p) => $p->id, $pickupPoints)),
                'bank_account_id' => $bank->id,
                'airline_id' => $singapore->id,
                'is_active' => true,
            ]);

            TourDate::where('tour_id', $baliTour->id)->delete();
            foreach ([
                ['2026-02-15', '2026-02-22', 2490, 2290, 1890, 1690, 30, 12],
                ['2026-03-01', '2026-03-08', 2590, 2390, 1990, 1790, 30, 8],
                ['2026-03-15', '2026-03-22', 2690, 2490, 2090, 1890, 30, 0],
                ['2026-04-05', '2026-04-12', 2890, 2690, 2190, 1990, 25, 0],
            ] as $d) {
                TourDate::create(['tour_id' => $baliTour->id, 'start_date' => $d[0], 'end_date' => $d[1], 'adult_price' => $d[2], 'adult_discounted_price' => $d[3], 'child_price' => $d[4], 'child_discounted_price' => $d[5], 'baby_price' => 0, 'capacity' => $d[6], 'booked' => $d[7], 'status' => 'available', 'single_supplement_price' => 450]);
            }
            $baliTour->categories()->sync([$asiaCategory->id]);
        }

        // ===================== DUBAİ TURU GÜNCELLE =====================
        $dubaiTour = Tour::where('code', 'DXB-5D')->first();
        if (!$dubaiTour) {
            $dubaiTour = Tour::create([
                'code' => 'DXB-5D',
                'title' => 'Dubai 5 Günlük Muhteşem Tur',
                'type' => 'flight',
                'nights' => 4,
                'brand_id' => $brand->id,
                'is_active' => true,
            ]);
        }
        
        if ($dubaiTour) {
            $dubaiTour->update([
                'title' => 'Dubai 5 Günlük Muhteşem Tur',
                'subtitle' => 'Burj Khalifa, Palm Jumeirah, Çöl Safari',
                'description' => json_encode([
                    'tr' => '<h2>Dubai\'ye Hoş Geldiniz!</h2><p>Dünyanın en etkileyici şehri Dubai\'yi keşfedin! Modern mimari, altın kumlarda çöl macerası, lüks alışveriş ve eşsiz deneyimler.</p><ul><li>Burj Khalifa 124. kat</li><li>Palm Jumeirah & Atlantis</li><li>4x4 Çöl Safari</li><li>Gold Souk alışverişi</li></ul>',
                    'en' => '<h2>Welcome to Dubai!</h2><p>Discover the world\'s most impressive city! Modern architecture, desert adventures, luxury shopping.</p>',
                    'de' => '<h2>Willkommen in Dubai!</h2><p>Entdecken Sie die beeindruckendste Stadt der Welt!</p>'
                ]),
                'itinerary' => json_encode([
                    ['day' => 1, 'title' => 'Dubai Varış', 'stops' => [
                        ['name' => 'Dubai Havalimanı', 'time' => '14:00', 'description' => 'VIP karşılama'],
                        ['name' => 'Burj Al Arab', 'time' => '16:00', 'description' => '7 yıldızlı otel fotoğraf'],
                        ['name' => 'Jumeirah Beach', 'time' => '17:00', 'description' => 'Plaj ve gün batımı'],
                        ['name' => 'La Mer', 'time' => '19:00', 'description' => 'Akşam yemeği']
                    ], 'images' => ['https://images.unsplash.com/photo-1512453979798-5ea266f8880c?w=800', 'https://images.unsplash.com/photo-1582672060674-bc2bd808a8b5?w=800']],
                    ['day' => 2, 'title' => 'Burj Khalifa & Dubai Mall', 'stops' => [
                        ['name' => 'Burj Khalifa', 'time' => '09:00', 'description' => '124. kat "At The Top"'],
                        ['name' => 'Dubai Mall', 'time' => '11:00', 'description' => 'Alışveriş ve Aquarium'],
                        ['name' => 'Dubai Fountain', 'time' => '18:00', 'description' => 'Su gösterisi'],
                        ['name' => 'Souk Al Bahar', 'time' => '19:30', 'description' => 'Akşam yemeği']
                    ], 'images' => ['https://images.unsplash.com/photo-1518684079-3c830dcef090?w=800', 'https://images.unsplash.com/photo-1577717903315-1691ae25ab3f?w=800']],
                    ['day' => 3, 'title' => 'Palm Jumeirah', 'stops' => [
                        ['name' => 'Palm Jumeirah', 'time' => '10:00', 'description' => 'Monorail turu'],
                        ['name' => 'Atlantis', 'time' => '11:30', 'description' => 'Lost Chambers Aquarium'],
                        ['name' => 'Dubai Marina', 'time' => '17:00', 'description' => 'Yat limanı yürüyüşü'],
                        ['name' => 'JBR Beach', 'time' => '19:00', 'description' => 'Akşam yemeği']
                    ], 'images' => ['https://images.unsplash.com/photo-1578862973063-64c6c9f6e7e7?w=800', 'https://images.unsplash.com/photo-1580674684081-7617fbf3d745?w=800']],
                    ['day' => 4, 'title' => 'Desert Safari', 'stops' => [
                        ['name' => 'Serbest Sabah', 'time' => '09:00', 'description' => 'Havuz veya Dubai Frame'],
                        ['name' => 'Safari Başlangıç', 'time' => '15:00', 'description' => '4x4 pick-up'],
                        ['name' => 'Dune Bashing', 'time' => '16:00', 'description' => 'Çöl macerası'],
                        ['name' => 'Deve Binişi', 'time' => '17:30', 'description' => 'Geleneksel deneyim'],
                        ['name' => 'BBQ & Show', 'time' => '19:30', 'description' => 'Akşam yemeği ve belly dance']
                    ], 'images' => ['https://images.unsplash.com/photo-1451337516015-6b6e9a44a8a3?w=800', 'https://images.unsplash.com/photo-1547234935-80c7145ec969?w=800']],
                    ['day' => 5, 'title' => 'Old Dubai & Dönüş', 'stops' => [
                        ['name' => 'Gold Souk', 'time' => '09:00', 'description' => 'Altın çarşısı'],
                        ['name' => 'Spice Souk', 'time' => '10:30', 'description' => 'Baharat çarşısı'],
                        ['name' => 'Abra Boat', 'time' => '11:30', 'description' => 'Dubai Creek geçişi'],
                        ['name' => 'Al Fahidi', 'time' => '12:30', 'description' => 'Tarihi mahalle'],
                        ['name' => 'Havalimanı', 'time' => '16:00', 'description' => 'Dönüş uçuşu']
                    ], 'images' => ['https://images.unsplash.com/photo-1512632578888-169bbbc64f33?w=800', 'https://images.unsplash.com/photo-1597659840241-37e2b9c2f55f?w=800']]
                ]),
                'images' => json_encode([
                    'https://images.unsplash.com/photo-1512453979798-5ea266f8880c?w=1200',
                    'https://images.unsplash.com/photo-1518684079-3c830dcef090?w=1200',
                    'https://images.unsplash.com/photo-1578862973063-64c6c9f6e7e7?w=1200',
                    'https://images.unsplash.com/photo-1451337516015-6b6e9a44a8a3?w=1200',
                    'https://images.unsplash.com/photo-1512632578888-169bbbc64f33?w=1200'
                ]),
                'highlights' => json_encode([
                    'tr' => ['Burj Khalifa 124. kat', 'Dubai Fountain', 'Palm Jumeirah', 'Atlantis Aquarium', '4x4 Çöl Safari', 'Deve binişi', 'Belly dance', 'Gold Souk'],
                    'en' => ['Burj Khalifa 124th floor', 'Dubai Fountain', 'Palm Jumeirah', 'Atlantis Aquarium', '4x4 Desert Safari', 'Camel ride', 'Belly dance', 'Gold Souk'],
                    'de' => ['Burj Khalifa 124. Etage', 'Dubai Fountain', 'Palm Jumeirah', 'Atlantis Aquarium', '4x4 Wüstensafari', 'Kamelritt']
                ]),
                'included' => json_encode([
                    'tr' => ['Emirates direkt uçuş', '4 gece 5* otel', 'Kahvaltılar', 'VIP transferler', 'Türkçe rehber', 'Burj Khalifa bileti', 'Dubai Aquarium', 'Palm Monorail', 'Atlantis girişi', 'Desert Safari + BBQ', 'Abra tekne turu', 'Seyahat sigortası'],
                    'en' => ['Emirates direct flight', '4 nights 5* hotel', 'Breakfasts', 'VIP transfers', 'English guide', 'Burj Khalifa ticket', 'Dubai Aquarium', 'Palm Monorail', 'Atlantis entrance', 'Desert Safari + BBQ', 'Abra boat tour', 'Travel insurance'],
                    'de' => ['Emirates Direktflug', '4 Nächte 5* Hotel', 'Frühstück', 'VIP Transfers', 'Deutschsprachiger Reiseleiter', 'Burj Khalifa Ticket']
                ]),
                'excluded' => json_encode([
                    'tr' => ['Öğle/akşam yemekleri', 'Kişisel harcamalar', 'Aquaventure (€80)', 'Dubai Frame (€15)', 'Ekstra bagaj', 'Minibar'],
                    'en' => ['Lunch/dinner', 'Personal expenses', 'Aquaventure (€80)', 'Dubai Frame (€15)', 'Extra baggage', 'Minibar'],
                    'de' => ['Mittag-/Abendessen', 'Persönliche Ausgaben', 'Aquaventure (€80)', 'Dubai Frame (€15)']
                ]),
                'pickup_points' => json_encode(array_map(fn($p) => $p->id, $pickupPoints)),
                'bank_account_id' => $bank->id,
                'airline_id' => $emirates->id,
                'is_active' => true,
            ]);

            TourDate::where('tour_id', $dubaiTour->id)->delete();
            foreach ([
                ['2026-03-01', '2026-03-05', 1290, 1090, 890, 790, 40, 18],
                ['2026-03-15', '2026-03-19', 1390, 1190, 990, 890, 40, 25],
                ['2026-04-01', '2026-04-05', 1490, 1290, 1090, 990, 35, 10],
                ['2026-04-15', '2026-04-19', 1590, 1390, 1190, 1090, 35, 0],
                ['2026-05-01', '2026-05-05', 1290, 1090, 890, 790, 40, 0],
            ] as $d) {
                TourDate::create(['tour_id' => $dubaiTour->id, 'start_date' => $d[0], 'end_date' => $d[1], 'adult_price' => $d[2], 'adult_discounted_price' => $d[3], 'child_price' => $d[4], 'child_discounted_price' => $d[5], 'baby_price' => 0, 'capacity' => $d[6], 'booked' => $d[7], 'status' => 'available', 'single_supplement_price' => 280]);
            }
            $dubaiTour->categories()->sync([$dubaiCategory->id]);
        }

        $this->command->info('✅ Turlar güncellendi!');
    }
}
