<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Brand;

class BrandsSeeder extends Seeder
{
    public function run(): void
    {
        $brands = [
            [
                'name' => 'Avusturya Gezi',
                'slug' => 'avusturya-gezi',
                'domain' => 'avusturyagezi.com',
                'is_active' => true,
            ],
            [
                'name' => 'Günübirlik Avrupa',
                'slug' => 'gunubirlik-avrupa',
                'domain' => 'gunubirlikavrupa.com',
                'is_active' => true,
            ],
            [
                'name' => 'Viyana Reisen',
                'slug' => 'viyana-reisen',
                'domain' => 'viyanareisen.com',
                'is_active' => true,
            ],
            [
                'name' => "Avrupa'dan Dubai",
                'slug' => 'avrupadan-dubai',
                'domain' => 'avrupadandubai.com',
                'is_active' => true,
            ],
            [
                'name' => "Avrupa'dan Umre",
                'slug' => 'avrupadan-umre',
                'domain' => 'avrupadanumre.com',
                'is_active' => true,
            ],
        ];

        foreach ($brands as $brandData) {
            Brand::updateOrCreate(
                ['slug' => $brandData['slug']],
                $brandData
            );
        }
    }
}
