<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Varsayılan admin kullanıcısı oluştur
        $admin = User::firstOrCreate(
            ['email' => 'admin@avusturyagezi.com'],
            [
                'name' => 'Admin User',
                'password' => Hash::make('admin123'),
                'user_type' => 'super_admin',
                'is_active' => true,
                'phone' => null,
            ]
        );

        if ($admin->wasRecentlyCreated) {
            $this->command->info('✅ Admin kullanıcısı oluşturuldu!');
            $this->command->info('   E-posta: admin@avusturyagezi.com');
            $this->command->info('   Şifre: admin123');
            $this->command->warn('   ⚠️  İlk girişten sonra şifrenizi değiştirin!');
        } else {
            $this->command->info('ℹ️  Admin kullanıcısı zaten mevcut.');
        }
    }
}
