<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoices', function (Blueprint $blueprint) {
            $blueprint->id();
            $blueprint->unsignedBigInteger('reservation_id')->index();
            $blueprint->string('invoice_no')->unique();
            $blueprint->date('invoice_date');
            $blueprint->decimal('total_price', 10, 2);
            $blueprint->decimal('discount_amount', 10, 2)->default(0);
            $blueprint->decimal('tax_amount', 10, 2)->default(0);
            $blueprint->string('status')->default('pending');
            $blueprint->json('billing_details')->nullable();
            $blueprint->json('items')->nullable();
            $blueprint->text('notes')->nullable();
            $blueprint->timestamps();
            $blueprint->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
