<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('flight_tickets', function (Blueprint $table) {
            $table->id();
            $table->foreignId('airline_id')->nullable()->constrained()->onDelete('set null');
            $table->string('type'); // one-way, round-trip
            $table->boolean('is_direct')->default(true);
            $table->decimal('price', 10, 2);
            $table->string('currency')->default('EUR');
            $table->string('slogan')->nullable();
            
            // Outbound
            $table->date('outbound_date');
            $table->string('outbound_time')->nullable();
            $table->string('outbound_departure_airport');
            $table->string('outbound_arrival_airport');
            
            // Inbound
            $table->date('inbound_date')->nullable();
            $table->string('inbound_time')->nullable();
            $table->string('inbound_departure_airport')->nullable();
            $table->string('inbound_arrival_airport')->nullable();
            
            $table->boolean('is_active')->default(true);
            $table->json('brand_ids')->nullable();
            $table->json('agent_group_ids')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('flight_tickets');
    }
};
