<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('villas', function (Blueprint $table) {
            $table->id();
            $table->json('title'); // Multilang title
            $table->string('slug')->unique();
            $table->decimal('price', 10, 2)->default(0);
            $table->decimal('discounted_price', 10, 2)->nullable();
            $table->string('location')->nullable();
            $table->integer('capacity_adults')->default(1);
            $table->integer('capacity_children')->default(0);
            $table->integer('bedrooms')->default(1);
            $table->integer('bathrooms')->default(1);
            $table->string('pool_type')->nullable(); // private, shared, etc.
            $table->string('checkin_time')->nullable();
            $table->string('checkout_time')->nullable();
            $table->json('description')->nullable();
            $table->json('highlights')->nullable();
            $table->json('amenities')->nullable();
            $table->json('gallery')->nullable();
            $table->json('faqs')->nullable();
            $table->json('distances')->nullable(); // beach: 500m, restaurant: 200m
            $table->boolean('is_active')->default(true);
            $table->json('brand_ids')->nullable();
            $table->json('agent_group_ids')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('villas');
    }
};
