<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('hotels', function (Blueprint $table) {
            $table->id();
            $table->json('title'); // Multilang title
            $table->string('slug')->unique();
            $table->decimal('price', 10, 2)->default(0);
            $table->decimal('discounted_price', 10, 2)->nullable();
            $table->integer('stars')->default(0);
            $table->string('location')->nullable();
            $table->json('board_types')->nullable(); // Bed & Breakfast, All Inclusive, etc.
            $table->json('amenities')->nullable();
            $table->json('gallery')->nullable();
            $table->json('faqs')->nullable();
            $table->json('description')->nullable();
            $table->boolean('is_active')->default(true);
            $table->json('brand_ids')->nullable();
            $table->json('agent_group_ids')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('hotels');
    }
};
