<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('activity_pricing_tiers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('activity_id')->constrained()->onDelete('cascade');
            $table->string('name');
            $table->decimal('price', 10, 2);
            $table->integer('min_age')->nullable();
            $table->integer('max_age')->nullable();
            $table->timestamps();
        });

        // Add pricing_data to activity_dates to handle overrides
        Schema::table('activity_dates', function (Blueprint $table) {
             $table->json('pricing_data')->nullable()->after('capacity')->comment('Fiyat grubu override verileri: {"tier_id": override_price}');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('activity_pricing_tiers');
        
        Schema::table('activity_dates', function (Blueprint $table) {
            $table->dropColumn('pricing_data');
        });
    }
};
