<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('activities', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->string('subtitle')->nullable();
            $table->text('description')->nullable();
            
            // Rich content
            $table->json('images')->nullable();
            $table->json('highlights')->nullable();
            $table->json('included')->nullable();
            $table->json('excluded')->nullable();
            $table->json('important_notes')->nullable();

            // Meta info
            $table->string('duration')->nullable(); // e.g. "6 Saat"
            $table->string('location')->nullable(); // e.g. "Dubai Çöl Bölgesi"
            
            // Pricing & Config
            $table->decimal('base_price', 10, 2)->default(0); // "Starting from" price
            $table->string('cancellation_policy')->nullable(); // e.g. "Son 24 Saat"
            $table->boolean('is_active')->default(true);
            $table->integer('order')->default(0);

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('activities');
    }
};
