<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sliders', function (Blueprint $attribute) {
            $attribute->id();
            $attribute->string('name');
            $attribute->string('image')->nullable();
            $attribute->string('link')->nullable();
            $attribute->integer('order')->default(0);
            $attribute->boolean('is_active')->default(true);
            $attribute->foreignId('brand_id')->constrained('brands')->onDelete('cascade');
            $attribute->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sliders');
    }
};
