<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('cash_desks', function (Blueprint $blueprint) {
            $blueprint->id();
            $blueprint->string('name');
            $blueprint->enum('type', ['bank', 'staff', 'guide', 'office'])->default('office');
            $blueprint->foreignId('responsible_id')->nullable()->constrained('users')->nullOnDelete();
            $blueprint->foreignId('bank_account_id')->nullable()->constrained('bank_accounts')->nullOnDelete();
            $blueprint->decimal('balance', 15, 2)->default(0);
            $blueprint->boolean('is_active')->default(true);
            $blueprint->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('cash_desks');
    }
};
