<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     * Global extras (tur ekstraları) and merchandise (mağaza ürünleri) – tur dışında tek yerden yönetilir.
     */
    public function up(): void
    {
        Schema::create('extras', function (Blueprint $table) {
            $table->id();
            $table->enum('type', ['extra', 'merchandise'])->default('extra')->comment('extra = tur ekstrası, merchandise = mağaza ürünü');
            $table->json('title')->nullable()->comment('tr, de, en');
            $table->json('description')->nullable()->comment('tr, de, en');
            $table->decimal('price', 10, 2)->default(0);
            $table->string('image', 500)->nullable();
            $table->unsignedSmallInteger('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('extras');
    }
};
