<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('error_logs', function (Blueprint $table) {
            $table->id();
            $table->string('source')->nullable()->comment('Frontend, Backend, API, etc.');
            $table->string('endpoint')->nullable()->comment('API endpoint or page URL');
            $table->string('method')->nullable()->comment('HTTP method');
            $table->string('error_type')->nullable()->comment('Exception class or error type');
            $table->text('error_message')->nullable();
            $table->json('error_details')->nullable()->comment('Additional error details');
            $table->longText('stack_trace')->nullable();
            $table->json('request_data')->nullable()->comment('Request payload/data');
            $table->foreignId('user_id')->nullable()->constrained('users')->onDelete('set null');
            $table->string('ip_address')->nullable();
            $table->text('user_agent')->nullable();
            $table->integer('status_code')->nullable();
            $table->boolean('resolved')->default(false);
            $table->timestamp('resolved_at')->nullable();
            $table->foreignId('resolved_by')->nullable()->constrained('users')->onDelete('set null');
            $table->text('notes')->nullable()->comment('Admin notes about the error');
            $table->timestamps();

            $table->index(['source', 'created_at']);
            $table->index(['resolved', 'created_at']);
            $table->index('error_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('error_logs');
    }
};
