<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tour_dates', function (Blueprint $table) {
            // Tarih bazlı otel seçenekleri
            // Format: [{"id": 1, "name": {"tr": "4* Standart Otel", "en": "..."}, "stars": 4, "price_modifier": 0, "image": "url", "description": {...}}]
            $table->json('hotel_options')->nullable()->after('transportation');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tour_dates', function (Blueprint $table) {
            $table->dropColumn('hotel_options');
        });
    }
};
