<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tours', function (Blueprint $table) {
            // Change seo_title to longtext to support JSON objects
            if (Schema::hasColumn('tours', 'seo_title')) {
                $table->longText('seo_title')->nullable()->change();
            } else {
                $table->longText('seo_title')->nullable()->after('subtitle');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tours', function (Blueprint $table) {
            // Revert back to text or string if needed, but keeping it text is safer
            $table->text('seo_title')->nullable()->change();
        });
    }
};
