<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tours', function (Blueprint $table) {
            // Change subtitle to text to support JSON objects
            $table->text('subtitle')->nullable()->change();
            
            // Add seo_title
            if (!Schema::hasColumn('tours', 'seo_title')) {
                $table->text('seo_title')->nullable()->after('subtitle');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tours', function (Blueprint $table) {
            $table->string('subtitle')->nullable()->change();
            $table->dropColumn('seo_title');
        });
    }
};
