<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('messages', function (Blueprint $col) {
            $col->string('sender_name')->nullable()->after('reservation_id');
            $col->string('sender_email')->nullable()->after('sender_name');
            $col->string('sender_phone')->nullable()->after('sender_email');
            $col->json('metadata')->nullable()->after('message');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('messages', function (Blueprint $col) {
            $col->dropColumn(['sender_name', 'sender_email', 'sender_phone', 'metadata']);
        });
    }
};
