<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->string('type')->default('string'); // string, json, boolean, number
            $table->string('group')->default('general'); // general, payment, email, etc.
            $table->text('description')->nullable();
            $table->timestamps();
        });

        // Insert default Stripe settings
        DB::table('settings')->insert([
            [
                'key' => 'stripe_key',
                'value' => env('STRIPE_KEY', ''),
                'type' => 'string',
                'group' => 'payment',
                'description' => 'Stripe Publishable Key (pk_test_... veya pk_live_...)',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'stripe_secret',
                'value' => env('STRIPE_SECRET', ''),
                'type' => 'string',
                'group' => 'payment',
                'description' => 'Stripe Secret Key (sk_test_... veya sk_live_...)',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'stripe_webhook_secret',
                'value' => env('STRIPE_WEBHOOK_SECRET', ''),
                'type' => 'string',
                'group' => 'payment',
                'description' => 'Stripe Webhook Secret (whsec_...)',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'stripe_test_mode',
                'value' => 'true',
                'type' => 'boolean',
                'group' => 'payment',
                'description' => 'Stripe Test Mode aktif mi?',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'stripe_3d_secure',
                'value' => 'false',
                'type' => 'boolean',
                'group' => 'payment',
                'description' => '3D Secure zorunlu mu?',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ]);
    }

    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
