<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('brand_testimonial', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('brand_id');
            $table->unsignedBigInteger('testimonial_id');
            $table->timestamps();

            $table->foreign('brand_id')->references('id')->on('brands')->onDelete('cascade');
            $table->foreign('testimonial_id')->references('id')->on('testimonials')->onDelete('cascade');
            
            $table->unique(['brand_id', 'testimonial_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('brand_testimonial');
    }
};
