<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('surveys', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('reservation_id')->nullable()->onDelete('cascade');
            $table->enum('type', ['tour', 'event', 'vacation', 'flight', 'car_rental']);
            $table->integer('nps_score')->nullable(); // 0-10
            $table->integer('csat_score')->nullable(); // 1-5
            $table->json('feedback')->nullable(); // Sorular ve cevaplar
            $table->text('comments')->nullable();
            $table->timestamp('submitted_at');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('surveys');
    }
};
