<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('reservations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('brand_id')->nullable()->nullable()->onDelete('set null');
            $table->unsignedBigInteger('user_id')->nullable()->nullable()->onDelete('set null');
            $table->unsignedBigInteger('tour_id')->nullable()->onDelete('cascade');
            $table->unsignedBigInteger('tour_date_id')->nullable()->onDelete('cascade');
            $table->string('reservation_code')->unique();
            $table->string('easy_code')->unique(); // AVST-XXXXXX formatında
            $table->enum('status', [
                'pending',
                'awaiting_approval',
                'approved',
                'payment_pending',
                'payment_partial',
                'payment_completed',
                'confirmed',
                'cancelled',
                'expired'
            ])->default('pending');
            $table->decimal('total_price', 10, 2);
            $table->decimal('paid_amount', 10, 2)->default(0);
            $table->decimal('remaining_amount', 10, 2);
            $table->decimal('discount_amount', 10, 2)->default(0);
            $table->string('flight_preference')->nullable(); // early, late, flexible
            $table->enum('flight_type', ['direct', 'connecting'])->nullable();
            $table->string('airline')->nullable();
            $table->text('custom_flight_notes')->nullable();
            $table->enum('payment_type', ['full', 'installment', 'partial'])->default('full');
            $table->enum('cancellation_policy', ['none', 'partial', 'full'])->default('none');
            $table->json('contact_info'); // fullName, email, phone, address, city, country, zipCode, invoiceType
            $table->unsignedBigInteger('coupon_id')->nullable()->nullable()->onDelete('set null');
            $table->unsignedBigInteger('gift_card_id')->nullable()->nullable()->onDelete('set null');
            $table->text('notes')->nullable();
            $table->text('admin_notes')->nullable();
            $table->unsignedBigInteger('approved_by')->nullable()->nullable()->onDelete('set null');
            $table->timestamp('approved_at')->nullable();
            $table->string('channel')->default('website'); // website, agent, chatbot
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('reservations');
    }
};
