<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tour_dates', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('tour_id')->nullable()->onDelete('cascade');
            $table->date('start_date');
            $table->date('end_date')->nullable();
            $table->time('start_time')->nullable();
            $table->time('end_time')->nullable();
            $table->decimal('adult_price', 10, 2);
            $table->decimal('adult_discounted_price', 10, 2)->nullable();
            $table->decimal('child_price', 10, 2)->nullable();
            $table->decimal('child_discounted_price', 10, 2)->nullable();
            $table->decimal('baby_price', 10, 2)->nullable();
            $table->decimal('baby_discounted_price', 10, 2)->nullable();
            $table->integer('capacity')->default(0);
            $table->integer('booked')->default(0);
            $table->enum('status', ['available', 'limited', 'full', 'closed'])->default('available');
            $table->decimal('single_supplement_price', 10, 2)->nullable();
            $table->json('pickup_point_prices')->nullable(); // Pickup point bazlı fiyat farkları
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tour_dates');
    }
};
