<?php
/**
 * extras tablosunu oluşturur. Bir kez çalıştırın:
 *   cd backend && php create_extras_table.php
 *
 * Veya tarayıcıdan: http://localhost:8000/create_extras_table.php
 * (Laravel public klasörüne kopyalayıp çalıştırırsanız; güvenlik için sonra silin.)
 */

$envPath = __DIR__ . '/.env';
if (!is_file($envPath)) {
    echo "Hata: .env bulunamadı.\n";
    exit(1);
}

$env = [];
foreach (file($envPath, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) as $line) {
    if (strpos(trim($line), '#') === 0) continue;
    if (preg_match('/^([^=]+)=(.*)$/', $line, $m)) {
        $key = trim($m[1]);
        $val = trim($m[2], " \t\n\r\0\x0B\"'");
        $env[$key] = $val;
    }
}

$host = $env['DB_HOST'] ?? '127.0.0.1';
$port = $env['DB_PORT'] ?? '3306';
$dbname = $env['DB_DATABASE'] ?? 'avusturya_gezi';
$user = $env['DB_USERNAME'] ?? 'root';
$pass = $env['DB_PASSWORD'] ?? '';

$dsn = "mysql:host={$host};port={$port};dbname={$dbname};charset=utf8mb4";

try {
    $pdo = new PDO($dsn, $user, $pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    ]);
} catch (PDOException $e) {
    echo "Veritabanı bağlantı hatası: " . $e->getMessage() . "\n";
    exit(1);
}

$sql = <<<'SQL'
CREATE TABLE IF NOT EXISTS `extras` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('extra','merchandise') NOT NULL DEFAULT 'extra',
  `title` json DEFAULT NULL,
  `description` json DEFAULT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `image` varchar(500) DEFAULT NULL,
  `sort_order` smallint unsigned NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
SQL;

try {
    $pdo->exec($sql);
    echo "extras tablosu oluşturuldu (veya zaten vardı).\n";

    // migrations kaydı ekle (php artisan migrate tekrar çalıştırırsa atlaması için)
    $migrationName = '2026_01_28_120000_create_extras_table';
    $stmt = $pdo->query("SELECT 1 FROM migrations WHERE migration = " . $pdo->quote($migrationName) . " LIMIT 1");
    if ($stmt->fetch() === false) {
        $batch = (int) $pdo->query("SELECT COALESCE(MAX(batch),0) + 1 AS b FROM migrations")->fetch(PDO::FETCH_ASSOC)['b'];
        $pdo->prepare("INSERT INTO migrations (migration, batch) VALUES (?, ?)")->execute([$migrationName, $batch]);
        echo "migrations tablosuna kayıt eklendi.\n";
    }
} catch (PDOException $e) {
    echo "Hata: " . $e->getMessage() . "\n";
    exit(1);
}

echo "Bitti. Panelden Ekstralar & Mağaza sayfasını kullanabilirsiniz.\n";
