<?php
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\Tour;

$tour = Tour::find(1);
if (!$tour) {
    echo "Tour 1 not found\n";
    exit;
}

echo "Tour ID: " . $tour->id . "\n";
echo "Title: " . $tour->title['tr'] . "\n";

echo "Extra Services (Raw): " . json_encode($tour->getAttributes()['extra_services'] ?? 'NULL') . "\n";
echo "Extra Services (Casted): " . json_encode($tour->extra_services) . "\n";

echo "Merch (Raw): " . json_encode($tour->getAttributes()['merchandise_items'] ?? 'NULL') . "\n";
echo "Merch (Casted): " . json_encode($tour->merchandise_items) . "\n";

echo "Pickup Points (Raw): " . json_encode($tour->getAttributes()['pickup_points'] ?? 'NULL') . "\n";
