// Find DENEME TUR
$tour = App\Models\Tour::whereRaw("JSON_UNQUOTE(JSON_EXTRACT(title, '$.tr')) LIKE '%DENEME TUR%'")->first();

if (!$tour) {
    echo "DENEME TUR bulunamadı!\n";
    exit;
}

echo "Tour bulundu: {$tour->id}\n";

// Get all reservations for this tour
$reservations = App\Models\Reservation::with('rooms')
    ->where('tour_id', $tour->id)
    ->whereHas('rooms')
    ->get();

if ($reservations->isEmpty()) {
    echo "DENEME TUR için rezervasyon bulunamadı!\n";
    exit;
}

$hotels = ['Novotel', 'deneme 3'];
$count = 0;

foreach ($reservations as $index => $res) {
    // Alternate between Novotel and deneme 3
    $hotel = $hotels[$index % 2];
    
    foreach ($res->rooms as $room) {
        $room->hotel_type = $hotel;
        $room->save();
    }
    
    echo "Updated Reservation #{$res->id} ({$res->reservation_code}) -> {$hotel}\n";
    $count++;
}

echo "Done! Updated {$count} DENEME TUR reservations.\n";
