<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Visa extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'slug',
        'price',
        'description',
        'processing_time',
        'requirements',
        'image',
        'is_active',
        'brand_ids',
        'agent_group_ids'
    ];

    protected $casts = [
        'requirements' => 'array',
        'price' => 'decimal:2',
        'is_active' => 'boolean',
        'brand_ids' => 'array',
        'agent_group_ids' => 'array'
    ];

    public function applications()
    {
        return $this->hasMany(VisaApplication::class);
    }
}
