<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Survey extends Model
{
    use HasFactory;

    protected $fillable = [
        'reservation_id',
        'type',
        'nps_score',
        'csat_score',
        'feedback',
        'comments',
        'submitted_at',
    ];

    protected $casts = [
        'feedback' => 'array',
        'submitted_at' => 'datetime',
    ];

    public function reservation()
    {
        return $this->belongsTo(Reservation::class);
    }
}
