<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Hotel extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'title',
        'slug',
        'price',
        'discounted_price',
        'stars',
        'location',
        'board_basis',
        'collection_tag',
        'summary',
        'board_types',
        'amenities',
        'flight_details',
        'room_details',
        'transfer_details',
        'dates',
        'highlights',
        'gallery',
        'faqs',
        'description',
        'video_url',
        'is_active',
        'brand_ids',
        'agent_group_ids'
    ];

    protected $casts = [
        'title' => 'array',
        'board_types' => 'array',
        'amenities' => 'array',
        'flight_details' => 'array',
        'room_details' => 'array',
        'transfer_details' => 'array',
        'dates' => 'array',
        'highlights' => 'array',
        'gallery' => 'array',
        'faqs' => 'array',
        'description' => 'array',
        'brand_ids' => 'array',
        'agent_group_ids' => 'array',
        'price' => 'decimal:2',
        'discounted_price' => 'decimal:2',
        'is_active' => 'boolean',
    ];
}
