<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Guest extends Model
{
    use HasFactory;

    protected $fillable = [
        'reservation_id',
        'room_id',
        'type',
        'first_name',
        'last_name',
        'gender',
        'date_of_birth',
        'citizenship',
        'passport_number',
        'passport_expiry',
        'pickup_point_id',
        'seat_number',
        'extra_seat_number',
        'departure_seat_number',
        'return_seat_number',
        'selected_extras',
        'notes',
        'security_notes',
        'created_by_name',
        'meal_selections', // { "categoryKey": "selectedOption", ... }
    ];

    protected $casts = [
        'date_of_birth' => 'date',
        'passport_expiry' => 'date',
        'selected_extras' => 'array',
        'meal_selections' => 'array',
    ];

    public function reservation()
    {
        return $this->belongsTo(Reservation::class);
    }

    public function room()
    {
        return $this->belongsTo(Room::class);
    }

    public function pickupPoint()
    {
        return $this->belongsTo(PickupPoint::class);
    }

    public function getFullNameAttribute()
    {
        return "{$this->first_name} {$this->last_name}";
    }
}
