<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GiftCard extends Model
{
    use HasFactory;

    protected $fillable = [
        'code',
        'qr_code',
        'amount',
        'balance',
        'status',
        'purchased_by',
        'recipient_email',
        'recipient_name',
        'message',
        'valid_until',
        'used_at',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'balance' => 'decimal:2',
        'valid_until' => 'date',
        'used_at' => 'datetime',
    ];

    public function purchasedBy()
    {
        return $this->belongsTo(User::class, 'purchased_by');
    }

    public function reservations()
    {
        return $this->hasMany(Reservation::class);
    }

    public function isValid()
    {
        if ($this->status !== 'active') return false;
        if ($this->balance <= 0) return false;
        if ($this->valid_until && now() > $this->valid_until) return false;
        return true;
    }
}
