<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FlightTicket extends Model
{
    use HasFactory;

    protected $fillable = [
        'airline_id',
        'type',
        'is_direct',
        'price',
        'currency',
        'slogan',
        'outbound_date',
        'outbound_time',
        'outbound_departure_airport',
        'outbound_arrival_airport',
        'inbound_date',
        'inbound_time',
        'inbound_departure_airport',
        'inbound_arrival_airport',
        'is_active',
        'brand_ids',
        'agent_group_ids',
    ];

    protected $casts = [
        'is_direct' => 'boolean',
        'is_active' => 'boolean',
        'brand_ids' => 'array',
        'agent_group_ids' => 'array',
        'price' => 'decimal:2',
        'outbound_date' => 'date',
        'inbound_date' => 'date',
    ];

    public function airline()
    {
        return $this->belongsTo(Airline::class);
    }
}
