<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\Brand;
use Symfony\Component\HttpFoundation\Response;

class VerifyApiKey
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $apiKey = $request->header('X-API-Key') ?: $request->get('api_key');

        if (!$apiKey) {
            return response()->json([
                'error' => 'API key is required',
                'message' => 'Please provide a valid API key in the X-API-Key header or api_key parameter'
            ], 401);
        }

        $brand = Brand::where('api_key', $apiKey)
            ->where('is_active', true)
            ->first();

        if (!$brand) {
            return response()->json([
                'error' => 'Invalid API key',
                'message' => 'The provided API key is not valid or the brand is inactive'
            ], 401);
        }

        // Brand bilgisini request'e ekle (controller'larda kullanılabilir)
        $request->merge(['brand' => $brand]);

        return $next($request);
    }
}
