<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Page;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class PageController extends Controller
{
    /**
     * Get page by slug
     */
    public function show(Request $request, string $slug): JsonResponse
    {
        $brandId = $request->header('X-Brand-Id'); // Multi-brand support

        $page = Page::published()
            ->forBrand($brandId)
            ->where('slug', $slug)
            ->firstOrFail();

        return response()->json([
            'id' => $page->id,
            'slug' => $page->slug,
            'title' => $page->title,
            'template' => $page->template,
            'sections' => $page->sections ?? [],
            'seo' => $page->seo ?? [
                'meta_title' => $page->title,
                'meta_description' => '',
            ],
        ]);
    }

    /**
     * Get all published pages
     */
    public function index(Request $request): JsonResponse
    {
        $brandId = $request->header('X-Brand-Id');

        $pages = Page::published()
            ->forBrand($brandId)
            ->orderBy('order')
            ->get(['id', 'slug', 'title', 'template']);

        return response()->json($pages);
    }
}
