<?php

namespace App\Http\Controllers\Api\Hotel;

use App\Http\Controllers\Controller;
use App\Models\Hotel;
use Illuminate\Http\Request;

class HotelController extends Controller
{
    public function index()
    {
        $hotels = Hotel::orderBy('created_at', 'desc')->get();
        return response()->json(['data' => $hotels]);
    }

    public function show($id)
    {
        if (is_numeric($id)) {
            $hotel = Hotel::findOrFail($id);
        } else {
            $hotel = Hotel::where('slug', $id)->firstOrFail();
        }
        return response()->json(['data' => $hotel]);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|array',
            'slug' => 'required|string|unique:hotels',
            'price' => 'required|numeric',
            'discounted_price' => 'nullable|numeric',
            'stars' => 'integer',
            'location' => 'nullable|string',
            'board_types' => 'nullable|array',
            'amenities' => 'nullable|array',
            'gallery' => 'nullable|array',
            'faqs' => 'nullable|array',
            'description' => 'nullable|array',
            'is_active' => 'boolean',
            'brand_ids' => 'nullable|array',
            'agent_group_ids' => 'nullable|array'
        ]);

        $hotel = Hotel::create($validated);
        return response()->json($hotel, 201);
    }

    public function update(Request $request, $id)
    {
        $hotel = Hotel::findOrFail($id);
        $validated = $request->validate([
            'title' => 'array',
            'slug' => 'string|unique:hotels,slug,' . $id,
            'price' => 'numeric',
            'discounted_price' => 'nullable|numeric',
            'stars' => 'integer',
            'location' => 'nullable|string',
            'board_types' => 'nullable|array',
            'amenities' => 'nullable|array',
            'gallery' => 'nullable|array',
            'faqs' => 'nullable|array',
            'description' => 'nullable|array',
            'is_active' => 'boolean',
            'brand_ids' => 'nullable|array',
            'agent_group_ids' => 'nullable|array'
        ]);

        $hotel->update($validated);
        return response()->json($hotel);
    }

    public function destroy($id)
    {
        Hotel::findOrFail($id)->delete();
        return response()->noContent();
    }
}
