#!/bin/bash

echo "🚀 MAMP ile Backend Kurulumu Başlatılıyor..."
echo ""

# MAMP PHP path'ini bul
MAMP_PHP=""
if [ -f /Applications/MAMP/bin/php/php8.4.1/bin/php ]; then
    MAMP_PHP="/Applications/MAMP/bin/php/php8.4.1/bin/php"
elif [ -f /Applications/MAMP/bin/php/php8.2.0/bin/php ]; then
    MAMP_PHP="/Applications/MAMP/bin/php/php8.2.0/bin/php"
elif [ -f /Applications/MAMP/bin/php/php8.1.0/bin/php ]; then
    MAMP_PHP="/Applications/MAMP/bin/php/php8.1.0/bin/php"
elif [ -f /Applications/MAMP/bin/php/php8.0.0/bin/php ]; then
    MAMP_PHP="/Applications/MAMP/bin/php/php8.0.0/bin/php"
else
    # Son çare: symlink'i takip et
    PHP_LINK=$(readlink /Applications/MAMP/bin/php/php 2>/dev/null)
    if [ ! -z "$PHP_LINK" ]; then
        MAMP_PHP="/Applications/MAMP/bin/php/$PHP_LINK/bin/php"
    fi
    if [ -z "$MAMP_PHP" ] || [ ! -f "$MAMP_PHP" ]; then
        echo "❌ MAMP PHP bulunamadı!"
        exit 1
    fi
fi

echo "✅ PHP bulundu: $MAMP_PHP"
$MAMP_PHP -v | head -1

# MAMP MySQL path'ini bul
MAMP_MYSQL=""
if [ -f /Applications/MAMP/Library/bin/mysql ]; then
    MAMP_MYSQL="/Applications/MAMP/Library/bin/mysql"
elif [ -f /Applications/MAMP/bin/mysql/bin/mysql ]; then
    MAMP_MYSQL="/Applications/MAMP/bin/mysql/bin/mysql"
fi

if [ -z "$MAMP_MYSQL" ]; then
    echo "⚠️  MySQL bulunamadı, manuel olarak veritabanı oluşturmanız gerekecek"
else
    echo "✅ MySQL bulundu: $MAMP_MYSQL"
fi

# Backend dizinine geç
cd "$(dirname "$0")"
echo ""
echo "📁 Backend dizini: $(pwd)"

# Composer kurulumu kontrol et
if ! command -v composer &> /dev/null; then
    echo ""
    echo "📦 Composer kuruluyor..."
    curl -sS https://getcomposer.org/installer | $MAMP_PHP
    sudo mv composer.phar /usr/local/bin/composer
    sudo chmod +x /usr/local/bin/composer
else
    echo "✅ Composer zaten kurulu"
fi

# Veritabanı oluştur
if [ ! -z "$MAMP_MYSQL" ]; then
    echo ""
    echo "🗄️  Veritabanı oluşturuluyor..."
    $MAMP_MYSQL -u root -proot -e "CREATE DATABASE IF NOT EXISTS avusturya_gezi CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;" 2>/dev/null || {
        echo "⚠️  MySQL şifresi gerekebilir. Lütfen şifrenizi girin:"
        read -s MYSQL_PASSWORD
        $MAMP_MYSQL -u root -p"$MYSQL_PASSWORD" -e "CREATE DATABASE IF NOT EXISTS avusturya_gezi CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"
    }
fi

# .env dosyasını güncelle
echo ""
echo "⚙️  .env dosyası güncelleniyor..."
sed -i '' 's|DB_PASSWORD=.*|DB_PASSWORD=root|g' .env 2>/dev/null || sed -i 's|DB_PASSWORD=.*|DB_PASSWORD=root|g' .env

# Composer paketleri
echo ""
echo "📦 Composer paketleri kuruluyor..."
$MAMP_PHP /usr/local/bin/composer install --no-interaction || {
    echo "⚠️  Composer PATH'te değil, direkt kullanılıyor..."
    $MAMP_PHP composer.phar install --no-interaction 2>/dev/null || {
        curl -sS https://getcomposer.org/installer | $MAMP_PHP
        $MAMP_PHP composer.phar install --no-interaction
    }
}

# Laravel key
echo ""
echo "🔑 Laravel key oluşturuluyor..."
$MAMP_PHP artisan key:generate --force

# Migration
echo ""
echo "🗄️  Veritabanı migration'ları çalıştırılıyor..."
$MAMP_PHP artisan migrate --force

# Seeder
echo ""
echo "🌱 Test verileri ekleniyor..."
$MAMP_PHP artisan db:seed --force

# Cache temizle
echo ""
echo "🧹 Cache temizleniyor..."
$MAMP_PHP artisan config:clear
$MAMP_PHP artisan cache:clear
$MAMP_PHP artisan route:clear

echo ""
echo "✅ Backend kurulumu tamamlandı!"
echo ""
echo "📋 Sonraki adımlar:"
echo "1. MAMP'i başlatın ve Apache/MySQL servislerinin çalıştığından emin olun"
echo "2. Backend server'ı başlatın:"
echo "   cd backend && $MAMP_PHP artisan serve"
echo ""
echo "   Veya MAMP'in Apache'sini kullanın (http://localhost:8888)"
echo ""
