# 🚀 Kurulum Rehberi

## Adım 1: PHP ve Composer Kurulumu

### macOS (Homebrew)

```bash
# PHP kurulumu
brew install php

# Composer kurulumu
curl -sS https://getcomposer.org/installer | php
sudo mv composer.phar /usr/local/bin/composer

# Versiyon kontrolü
php -v
composer --version
```

### Alternatif: Laravel Herd (macOS için önerilen)

```bash
# Laravel Herd kurulumu (PHP + Composer + Laravel CLI)
brew install laravel/herd/herd
herd install
```

## Adım 2: Veritabanı Kurulumu

### MySQL (Homebrew)

```bash
brew install mysql
brew services start mysql
mysql_secure_installation
```

### PostgreSQL (Homebrew)

```bash
brew install postgresql@15
brew services start postgresql@15
```

## Adım 3: Redis Kurulumu (Opsiyonel)

```bash
brew install redis
brew services start redis
```

## Adım 4: Laravel Projesi Oluşturma

```bash
cd "/Users/denizyildiz/Desktop/avusturya gezi yeni/backend"

# Laravel projesi oluştur
composer create-project laravel/laravel . --prefer-dist

# Veya mevcut projeyi güncelle
composer install
```

## Adım 5: Environment Yapılandırması

```bash
# .env dosyasını kopyala
cp .env.example .env

# Application key oluştur
php artisan key:generate
```

`.env` dosyasını düzenleyin:

```env
APP_NAME="Avusturya Gezi API"
APP_ENV=local
APP_DEBUG=true
APP_URL=http://localhost:8000

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=avusturya_gezi
DB_USERNAME=root
DB_PASSWORD=

STRIPE_KEY=sk_test_...
STRIPE_SECRET=sk_test_...
STRIPE_WEBHOOK_SECRET=whsec_...

FRONTEND_URL=http://localhost:3000
```

## Adım 6: Gerekli Paketlerin Kurulumu

```bash
# Authentication
composer require laravel/sanctum

# Payment
composer require laravel/cashier
composer require stripe/stripe-php

# Multi-tenancy (Çok markalı yapı)
composer require spatie/laravel-multitenancy

# Permission (RBAC)
composer require spatie/laravel-permission

# Media Library (Dosya yönetimi)
composer require spatie/laravel-media-library

# PDF Generation
composer require barryvdh/laravel-dompdf

# QR Code
composer require simplesoftwareio/simple-qrcode

# API Resources (Response formatting)
# Laravel'de varsayılan olarak gelir
```

## Adım 7: Sanctum Yapılandırması

```bash
php artisan vendor:publish --provider="Laravel\Sanctum\SanctumServiceProvider"
php artisan migrate
```

## Adım 8: Veritabanı Oluşturma

```bash
# MySQL'de veritabanı oluştur
mysql -u root -p
CREATE DATABASE avusturya_gezi CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
EXIT;
```

## Adım 9: Migration ve Seeder

```bash
# Migration dosyalarını çalıştır
php artisan migrate

# Seeder çalıştır (test verileri için)
php artisan db:seed
```

## Adım 10: Storage Link

```bash
php artisan storage:link
```

## Adım 11: Server Başlatma

```bash
# Development server
php artisan serve

# Veya Laravel Herd kullanıyorsanız
# Otomatik olarak çalışır
```

API artık `http://localhost:8000/api` adresinde çalışıyor!

## 🔍 Kontrol

```bash
# API test
curl http://localhost:8000/api/health

# Veya browser'da
open http://localhost:8000/api/health
```

## 📝 Sonraki Adımlar

1. API endpoint'lerini test edin
2. Frontend'i API'ye bağlayın
3. Stripe webhook'larını yapılandırın
4. Production ortamı için hazırlık yapın
