# Docker ile Backend Kurulumu

## 🐳 Docker Kurulumu

Eğer Docker Desktop kuruluysa, aşağıdaki adımları izleyin:

## 📋 Adımlar

### 1. Docker Desktop'ı Başlatın
Docker Desktop uygulamasını açın ve çalıştığından emin olun.

### 2. Backend Dizinine Gidin
```bash
cd "/Users/denizyildiz/Desktop/avusturya gezi yeni/backend"
```

### 3. Docker Compose ile Başlatın
```bash
docker-compose up -d
```

### 4. Composer Paketlerini Kurun
```bash
docker-compose exec php composer install
```

### 5. Laravel Key Oluşturun
```bash
docker-compose exec php php artisan key:generate
```

### 6. Veritabanı Migration'larını Çalıştırın
```bash
docker-compose exec php php artisan migrate
```

### 7. Test Verilerini Ekleyin
```bash
docker-compose exec php php artisan db:seed
```

## ✅ Tamamlandı!

Backend şu adreste çalışacak: http://localhost:8000

## 🛑 Durdurma

Docker container'larını durdurmak için:
```bash
docker-compose down
```

## 📝 Notlar

- Docker Desktop'ın çalıştığından emin olun
- İlk kurulum biraz zaman alabilir (image'ler indirilecek)
- Veritabanı otomatik olarak oluşturulacak
