# 📡 API Endpoints Dokümantasyonu

## Base URL
```
http://localhost:8000/api
```

## Authentication

Tüm protected endpoint'ler için `Authorization: Bearer {token}` header'ı gereklidir.

---

## 🔐 Authentication Endpoints

### Register
```http
POST /api/auth/register
Content-Type: application/json

{
  "name": "Ahmet Yılmaz",
  "email": "ahmet@example.com",
  "password": "password123",
  "password_confirmation": "password123",
  "phone": "+43 6XX XXX XX XX"
}
```

**Response:**
```json
{
  "user": {
    "id": 1,
    "name": "Ahmet Yılmaz",
    "email": "ahmet@example.com"
  },
  "token": "1|xxxxxxxxxxxxx"
}
```

### Login
```http
POST /api/auth/login
Content-Type: application/json

{
  "email": "ahmet@example.com",
  "password": "password123"
}
```

**Response:**
```json
{
  "user": {
    "id": 1,
    "name": "Ahmet Yılmaz",
    "email": "ahmet@example.com"
  },
  "token": "1|xxxxxxxxxxxxx"
}
```

### Get Current User
```http
GET /api/auth/user
Authorization: Bearer {token}
```

### Logout
```http
POST /api/auth/logout
Authorization: Bearer {token}
```

---

## 🎯 Tours Endpoints

### List Tours
```http
GET /api/tours?page=1&per_page=20&category=bus&departure=viyana
```

**Query Parameters:**
- `page`: Sayfa numarası
- `per_page`: Sayfa başına kayıt
- `category`: Kategori filtresi (bus, flight, event)
- `departure`: Kalkış noktası
- `search`: Arama terimi

**Response:**
```json
{
  "data": [
    {
      "id": 1,
      "title": "Bali ve Singapur Turu",
      "subtitle": "Egzotik Bir Kaçış",
      "image": "https://...",
      "nights": 7,
      "type": "flight",
      "current_price": 1999,
      "original_price": 2499
    }
  ],
  "meta": {
    "current_page": 1,
    "total": 50
  }
}
```

### Get Tour Detail
```http
GET /api/tours/{id}
```

### Get Tour Dates
```http
GET /api/tours/{id}/dates
```

**Response:**
```json
{
  "data": [
    {
      "id": 1,
      "start_date": "2025-12-07",
      "end_date": "2025-12-14",
      "price": 1999,
      "occupancy": 45,
      "status": "available"
    }
  ]
}
```

---

## 📋 Reservations Endpoints

### Create Reservation
```http
POST /api/reservations
Authorization: Bearer {token}
Content-Type: application/json

{
  "tour_id": 1,
  "tour_date_id": 1,
  "flight_preference": "flight-included",
  "flight_type": "direct",
  "airline": "pegasus",
  "rooms": [
    {
      "room_type": "double",
      "adults": 2,
      "students": 0,
      "children": 0,
      "babies": 0,
      "hotel_type": "4-star"
    }
  ],
  "guests": [
    {
      "first_name": "Ahmet",
      "last_name": "Yılmaz",
      "gender": "male",
      "dob": "1990-01-01",
      "citizenship": "Türkiye",
      "pickup_point_id": 2,
      "seat_number": 12
    }
  ],
  "extras": [1, 2],
  "merchandise": {
    "1": 2
  },
  "contact_info": {
    "full_name": "Ahmet Yılmaz",
    "email": "ahmet@example.com",
    "phone": "+43 6XX XXX XX XX",
    "address": "Teststraße 123",
    "city": "Viyana",
    "zip_code": "1010",
    "country": "Avusturya",
    "invoice_type": "individual"
  }
}
```

**Response:**
```json
{
  "data": {
    "id": 1,
    "reservation_code": "AVST-009123",
    "status": "pending",
    "total_price": 2199,
    "message": "Rezervasyonunuz alındı. Onaylandıktan sonra ödeme bilgileri gönderilecektir."
  }
}
```

### List My Reservations
```http
GET /api/reservations?status=pending
Authorization: Bearer {token}
```

### Get Reservation Detail
```http
GET /api/reservations/{id}
Authorization: Bearer {token}
```

### Cancel Reservation
```http
PATCH /api/reservations/{id}/cancel
Authorization: Bearer {token}
```

---

## 💳 Payment Endpoints

### Create Payment Link
```http
POST /api/payments/create-link
Authorization: Bearer {token}
Content-Type: application/json

{
  "reservation_id": 1,
  "payment_method": "stripe"
}
```

**Response:**
```json
{
  "data": {
    "payment_link": "https://buy.stripe.com/...",
    "expires_at": "2025-01-25T12:00:00Z",
    "easy_code": "AVST-009123"
  }
}
```

### Checkout (Direct Payment)
```http
POST /api/payments/checkout
Authorization: Bearer {token}
Content-Type: application/json

{
  "reservation_id": 1,
  "payment_method": "stripe",
  "payment_intent_id": "pi_xxxxx"
}
```

### Get Payment Status
```http
GET /api/payments/{id}/status
Authorization: Bearer {token}
```

---

## 👤 Customer Panel Endpoints

### Dashboard
```http
GET /api/customer/dashboard
Authorization: Bearer {token}
```

**Response:**
```json
{
  "data": {
    "upcoming_trips": 2,
    "total_debt": 1299,
    "loyalty_points": 450,
    "recent_reservations": [...]
  }
}
```

### My Reservations
```http
GET /api/customer/reservations
Authorization: Bearer {token}
```

### My Payments
```http
GET /api/customer/payments
Authorization: Bearer {token}
```

### Download Document
```http
GET /api/customer/documents/{reservationId}/download/{type}
Authorization: Bearer {token}
```

**Document Types:**
- `boarding-pass`: Biniş kartı (QR)
- `voucher`: Voucher
- `program`: Program ve koşullar
- `invoice`: Fatura

---

## 👨‍💼 Admin Endpoints

### Get Pending Reservations
```http
GET /api/admin/reservations/pending
Authorization: Bearer {token}
```

### Approve Reservation
```http
POST /api/admin/reservations/{id}/approve
Authorization: Bearer {token}
Content-Type: application/json

{
  "notes": "Onaylandı"
}
```

**Response:**
```json
{
  "data": {
    "id": 1,
    "status": "approved",
    "payment_link": "https://buy.stripe.com/...",
    "message": "Rezervasyon onaylandı. Ödeme linki gönderildi."
  }
}
```

### Reject Reservation
```http
POST /api/admin/reservations/{id}/reject
Authorization: Bearer {token}
Content-Type: application/json

{
  "reason": "Kontenjan doldu"
}
```

### Bulk Approve
```http
POST /api/admin/reservations/bulk-approve
Authorization: Bearer {token}
Content-Type: application/json

{
  "reservation_ids": [1, 2, 3]
}
```

---

## 🔔 Webhooks

### Stripe Webhook
```http
POST /api/webhooks/stripe
X-Stripe-Signature: {signature}
```

---

## 📝 Error Responses

### Validation Error (422)
```json
{
  "message": "The given data was invalid.",
  "errors": {
    "email": ["The email field is required."]
  }
}
```

### Unauthorized (401)
```json
{
  "message": "Unauthenticated."
}
```

### Not Found (404)
```json
{
  "message": "Resource not found."
}
```

---

## 🔄 Status Codes

- `200` - Success
- `201` - Created
- `400` - Bad Request
- `401` - Unauthorized
- `403` - Forbidden
- `404` - Not Found
- `422` - Validation Error
- `500` - Server Error
